/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.privacy.rcp.data;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.recommenders.internal.privacy.rcp.data.ICategory;
import org.eclipse.recommenders.internal.privacy.rcp.data.Principal;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrivatePermission;
import org.eclipse.swt.graphics.Image;

public class PrincipalCategory
implements ICategory {
    private final Principal principal;
    private final Set<PrivatePermission> permissionSet = new HashSet<PrivatePermission>();

    public PrincipalCategory(Principal principal) {
        this.principal = (Principal)Preconditions.checkNotNull((Object)principal);
    }

    public String getId() {
        return this.principal.getId();
    }

    public String getName() {
        return this.principal.getName();
    }

    public String getDescription() {
        return this.principal.getDescription();
    }

    @Override
    public String getText() {
        return this.getName();
    }

    @Override
    public String getTooltip() {
        return this.getDescription();
    }

    @Override
    public Image getImageDescriptor() {
        return this.principal.getIcon().createImage();
    }

    @Override
    public Set<PrivatePermission> getPermissions() {
        return Collections.unmodifiableSet(this.permissionSet);
    }

    public void addPermissions(PrivatePermission ... permissions) {
        PrivatePermission[] privatePermissionArray = permissions;
        int n = permissions.length;
        int n2 = 0;
        while (n2 < n) {
            PrivatePermission permission = privatePermissionArray[n2];
            this.permissionSet.add(permission);
            ++n2;
        }
    }

    public String toString() {
        return this.principal.getName();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrincipalCategory other = (PrincipalCategory)obj;
        return this.principal.equals(other.principal);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.principal == null ? 0 : this.principal.hashCode());
        return result;
    }
}

