/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.privacy.rcp.data;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.recommenders.internal.privacy.rcp.data.ICategory;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrivatePermission;
import org.eclipse.recommenders.privacy.rcp.IPrivacySettingsService;
import org.eclipse.recommenders.privacy.rcp.PermissionState;

public final class PrivacySettingsSerciveHelper {
    public static Set<PrivatePermission> loadApproved(IPrivacySettingsService service, Set<? extends ICategory> categories) {
        return Sets.filter(PrivacySettingsSerciveHelper.getCategoriesPermissions(categories), (Predicate)new LoadApprovedPredicate(service));
    }

    public static Set<PrivatePermission> suggestApproved(IPrivacySettingsService service, Set<? extends ICategory> categories) {
        return Sets.filter(PrivacySettingsSerciveHelper.getCategoriesPermissions(categories), (Predicate)new SuggestApprovedPredicate(service));
    }

    public static void store(IPrivacySettingsService service, Set<PrivatePermission> approvedPermissions, Set<PrivatePermission> disapprovedPermissions) {
        for (PrivatePermission permission : approvedPermissions) {
            service.setState(permission.getPrincipalId(), permission.getDatumId(), PermissionState.APPROVED);
        }
        for (PrivatePermission permission : disapprovedPermissions) {
            service.setState(permission.getPrincipalId(), permission.getDatumId(), PermissionState.DISAPPROVED);
        }
    }

    public static Set<PrivatePermission> getCategoriesPermissions(Set<? extends ICategory> categories) {
        HashSet permissions = Sets.newHashSet();
        for (ICategory iCategory : categories) {
            for (PrivatePermission permission : iCategory.getPermissions()) {
                permissions.add(permission);
            }
        }
        return permissions;
    }

    public static Set<PrivatePermission> getPermissions(Set<PrivatePermission> permissionSet, String principalId, String ... datumsIds) {
        return Sets.filter(permissionSet, (Predicate)new ExtractPermissionsPredicate(principalId, datumsIds));
    }

    private PrivacySettingsSerciveHelper() {
    }

    public static final class ExtractPermissionsPredicate
    implements Predicate<PrivatePermission> {
        private final String principalId;
        private final String[] datumIds;

        private ExtractPermissionsPredicate(String principalId, String[] datumIds) {
            this.principalId = principalId;
            this.datumIds = datumIds;
        }

        public boolean apply(PrivatePermission permission) {
            String[] stringArray = this.datumIds;
            int n = this.datumIds.length;
            int n2 = 0;
            while (n2 < n) {
                String datumId = stringArray[n2];
                if (permission.getPrincipalId().equals(this.principalId) && permission.getDatumId().equals(datumId)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    public static final class LoadApprovedPredicate
    implements Predicate<PrivatePermission> {
        private final IPrivacySettingsService service;

        private LoadApprovedPredicate(IPrivacySettingsService service) {
            this.service = service;
        }

        public boolean apply(PrivatePermission permission) {
            return this.service.isApproved(permission.getPrincipalId(), permission.getDatumId());
        }
    }

    public static final class SuggestApprovedPredicate
    implements Predicate<PrivatePermission> {
        private final IPrivacySettingsService service;

        private SuggestApprovedPredicate(IPrivacySettingsService service) {
            this.service = service;
        }

        public boolean apply(PrivatePermission permission) {
            if (permission.isSuggestApproval()) {
                return true;
            }
            return !this.service.isNeverApproved(permission.getDatumId());
        }
    }
}

