/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.privacy.rcp.data;

import com.google.common.base.Optional;
import java.util.Objects;
import org.eclipse.recommenders.internal.privacy.rcp.data.ApprovalType;
import org.eclipse.recommenders.internal.privacy.rcp.data.ExtensionReader;
import org.eclipse.recommenders.internal.privacy.rcp.data.Principal;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrivateDatum;
import org.eclipse.recommenders.privacy.rcp.IConfigurationDialogFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public final class PrivatePermission {
    private final PrivateDatum datum;
    private final Principal principal;
    private final String purpose;
    private final String policyUri;
    private final boolean suggestApproval;
    private final ApprovalType approvalType;
    private final ExtensionReader extensionReader;

    public PrivatePermission(PrivateDatum datum, Principal principal, String purpose, String policyUri, ApprovalType approvalType, ExtensionReader extensionReader) {
        this(datum, principal, purpose, policyUri, false, approvalType, extensionReader);
    }

    public PrivatePermission(PrivateDatum datum, Principal principal, String purpose, String policyUri, boolean suggestApproval, ApprovalType approvalType, ExtensionReader extensionReader) {
        this.datum = Objects.requireNonNull(datum);
        this.principal = Objects.requireNonNull(principal);
        this.purpose = Objects.requireNonNull(purpose);
        this.policyUri = Objects.requireNonNull(policyUri);
        this.suggestApproval = suggestApproval;
        this.approvalType = Objects.requireNonNull(approvalType);
        this.extensionReader = Objects.requireNonNull(extensionReader);
    }

    public String getDatumId() {
        return this.datum.getId();
    }

    public String getDatumName() {
        return this.datum.getName();
    }

    public Image getDatumIcon() {
        return this.datum.getIcon().createImage();
    }

    public String getPrincipalId() {
        return this.principal.getId();
    }

    public String getPrincipalName() {
        return this.principal.getName();
    }

    public Image getPrincipalIcon() {
        return this.principal.getIcon().createImage();
    }

    public String getPurpose() {
        return this.purpose;
    }

    public String getPolicyUri() {
        return this.policyUri;
    }

    public boolean isSuggestApproval() {
        return this.suggestApproval;
    }

    public ApprovalType getApprovalType() {
        return this.approvalType;
    }

    public boolean isAdvancedPreferencesSupported() {
        return this.extensionReader.isAdvancedPreferencesSupported(this);
    }

    public void openConfigurationDialog(Shell shell) {
        Optional<IConfigurationDialogFactory> factory = this.getConfigurationDialog();
        if (factory.isPresent()) {
            IConfigurationDialogFactory configurationDialog = (IConfigurationDialogFactory)factory.get();
            configurationDialog.open(shell);
        }
    }

    private Optional<IConfigurationDialogFactory> getConfigurationDialog() {
        return this.extensionReader.getConfigurationDialog(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        PrivatePermission that = (PrivatePermission)other;
        return Objects.equals(this.datum, that.datum) && Objects.equals(this.principal, that.principal) && Objects.equals(this.purpose, that.purpose) && Objects.equals(this.policyUri, that.policyUri) && Objects.equals(this.suggestApproval, that.suggestApproval) && Objects.equals((Object)this.approvalType, (Object)that.approvalType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.datum, this.principal, this.purpose, this.policyUri, this.suggestApproval, this.approvalType});
    }
}

