/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.privacy.rcp.dialogs;

import com.ibm.icu.text.MessageFormat;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.recommenders.internal.privacy.rcp.data.ICategory;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrivacySettingsSerciveHelper;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrivatePermission;
import org.eclipse.recommenders.internal.privacy.rcp.l10n.Messages;
import org.eclipse.recommenders.internal.privacy.rcp.preferences.PreferencesHelper;
import org.eclipse.recommenders.internal.privacy.rcp.preferences.PrivacyPreferencePage;
import org.eclipse.recommenders.internal.privacy.rcp.widgets.CompositeType;
import org.eclipse.recommenders.internal.privacy.rcp.widgets.PermissionWidget;
import org.eclipse.recommenders.privacy.rcp.IPrivacySettingsService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class PermissionApprovalDialog
extends Dialog {
    private final IPrivacySettingsService service;
    private final Set<? extends ICategory> datumSet;
    private final Set<? extends ICategory> principalSet;
    private final Set<PrivatePermission> detectedPermissions;
    private PermissionWidget permissionWidget;
    private String title = Messages.APPROVAL_DIALOG_TITLE;
    private String description = Messages.APPROVAL_DIALOG_MESSAGE;
    private String okButtonText = Messages.BUTTON_OK;
    private String cancelButtonText = Messages.BUTTON_NOT_NOW;

    public PermissionApprovalDialog(Shell parentShell, IPrivacySettingsService service, Set<? extends ICategory> datumSet, Set<? extends ICategory> principalSet, Set<PrivatePermission> detectedPermissions) {
        super(parentShell);
        this.service = service;
        this.datumSet = datumSet;
        this.principalSet = principalSet;
        this.detectedPermissions = detectedPermissions;
    }

    public void setTitle(String customTitle) {
        this.title = customTitle != null ? customTitle : Messages.APPROVAL_DIALOG_TITLE;
    }

    public void setDescription(String customDesc) {
        this.description = customDesc != null ? customDesc : Messages.APPROVAL_DIALOG_MESSAGE;
    }

    public void setOkButtonText(String customOk) {
        this.okButtonText = customOk != null ? customOk : Messages.BUTTON_OK;
    }

    public void setCancelButtonText(String customCancel) {
        this.cancelButtonText = customCancel != null ? customCancel : Messages.BUTTON_NOT_NOW;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.createDescription(container, this.description);
        this.createPermissionWidget(container);
        this.createLink(container);
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    private void createDescription(Composite parent, String message) {
        Label label = new Label(parent, 64);
        label.setText(message);
        GridDataFactory.fillDefaults().hint(300, -1).applyTo((Control)label);
    }

    private void createPermissionWidget(Composite container) {
        this.permissionWidget = new PermissionWidget(this.datumSet, this.principalSet);
        this.permissionWidget.setCheckedPermission(this.loadPermissions(this.principalSet));
        this.permissionWidget.setShownPermission(this.detectedPermissions);
        this.permissionWidget.setTopComposite(CompositeType.PRINCIPAL);
        this.permissionWidget.createContents(container);
    }

    private void createLink(Composite container) {
        Link link = new Link(container, 0);
        String linkToPreferencePage = PreferencesHelper.createLinkLabelToPreferencePage("org.eclipse.recommenders.privacy.rcp.preferencesPages.privacy");
        link.setText(MessageFormat.format((String)Messages.PREF_LINK_MESSAGE, (Object[])new Object[]{linkToPreferencePage}));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)"org.eclipse.recommenders.privacy.rcp.preferencesPages.privacy", null, null);
                PrivacyPreferencePage preferencePage = (PrivacyPreferencePage)((Object)dialog.getSelectedPage());
                preferencePage.checkElements(PermissionApprovalDialog.this.permissionWidget.getAllApprovedPermissions());
                PermissionApprovalDialog.this.cancelPressed();
                dialog.open();
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button ok = this.getButton(0);
        ok.setText(this.okButtonText);
        this.setButtonLayoutData(ok);
        Button cancel = this.getButton(1);
        cancel.setText(this.cancelButtonText);
        this.setButtonLayoutData(cancel);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    private Set<PrivatePermission> loadPermissions(Set<? extends ICategory> input) {
        return PrivacySettingsSerciveHelper.suggestApproved(this.service, input);
    }

    protected void okPressed() {
        PrivacySettingsSerciveHelper.store(this.service, this.permissionWidget.getApprovedPermissions(this.detectedPermissions), this.permissionWidget.getDisapprovedPermissions(this.detectedPermissions));
        super.okPressed();
    }
}

