/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.privacy.rcp.preferences;

import java.util.Set;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.recommenders.internal.privacy.rcp.data.DatumCategory;
import org.eclipse.recommenders.internal.privacy.rcp.data.ExtensionReader;
import org.eclipse.recommenders.internal.privacy.rcp.data.ICategory;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrincipalCategory;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrivacySettingsSerciveHelper;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrivatePermission;
import org.eclipse.recommenders.internal.privacy.rcp.l10n.Messages;
import org.eclipse.recommenders.internal.privacy.rcp.widgets.PermissionWidget;
import org.eclipse.recommenders.privacy.rcp.IPrivacySettingsService;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class PrivacyPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IPrivacySettingsService service;
    private ExtensionReader extensionReader;
    private PermissionWidget permissionWidget;

    public void init(IWorkbench workbench) {
        this.setMessage(Messages.PRIVACY_PREFPAGE_TITLE);
        BundleContext bundleContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        IEclipseContext eclipseContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        this.service = (IPrivacySettingsService)eclipseContext.get(IPrivacySettingsService.class);
        this.extensionReader = new ExtensionReader();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.createDescription(composite, Messages.PRIVACY_PREFPAGE_DESCRIPTION);
        this.createPermissionWidget(composite);
        Dialog.applyDialogFont((Control)composite);
        return parent;
    }

    private void createDescription(Composite parent, String message) {
        Label label = new Label(parent, 64);
        label.setText(message);
        GridDataFactory.fillDefaults().hint(300, -1).applyTo((Control)label);
    }

    private void createPermissionWidget(Composite parent) {
        Set<DatumCategory> datumCategorySet = this.extensionReader.getDatumCategory();
        Set<PrincipalCategory> principalCategorySet = this.extensionReader.getPrincipalCategory();
        this.permissionWidget = new PermissionWidget(datumCategorySet, principalCategorySet);
        this.permissionWidget.setCheckedPermission(this.loadPermissions(principalCategorySet));
        this.permissionWidget.setShownPermission(PrivacySettingsSerciveHelper.getCategoriesPermissions(principalCategorySet));
        this.permissionWidget.createContents(parent);
    }

    public void checkElements(Set<PrivatePermission> permissions) {
        this.permissionWidget.checkElements(permissions);
    }

    private Set<PrivatePermission> loadPermissions(Set<? extends ICategory> input) {
        return PrivacySettingsSerciveHelper.loadApproved(this.service, input);
    }

    public void performApply() {
        PrivacySettingsSerciveHelper.store(this.service, this.permissionWidget.getAllApprovedPermissions(), this.permissionWidget.getAllDisapprovedPermissions());
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }
}

