/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.privacy.rcp.widgets;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.recommenders.internal.privacy.rcp.data.ICategory;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrivacySettingsSerciveHelper;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrivatePermission;
import org.eclipse.recommenders.internal.privacy.rcp.l10n.Messages;
import org.eclipse.recommenders.internal.privacy.rcp.widgets.CategoryContentProvider;
import org.eclipse.recommenders.internal.privacy.rcp.widgets.CompositeType;
import org.eclipse.recommenders.internal.privacy.rcp.widgets.DatumLabelProvider;
import org.eclipse.recommenders.internal.privacy.rcp.widgets.PrincipalLabelProvider;
import org.eclipse.recommenders.internal.privacy.rcp.widgets.PrivacySorter;
import org.eclipse.recommenders.internal.privacy.rcp.widgets.PrivacyTooltipSupport;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PermissionWidget {
    private CheckboxTreeViewer datumPermissionsViewer;
    private final Set<? extends ICategory> datumPermissionsInput;
    private CheckboxTreeViewer principalPermissionsViewer;
    private final Set<? extends ICategory> principalPermissionsInput;
    private Set<PrivatePermission> checkedPermissions = Collections.emptySet();
    private Set<PrivatePermission> shownPermissions = Collections.emptySet();
    private Shell parentShell;
    private StackLayout treeViewerStack;
    private Composite stackComposite;
    private Composite datumComposite;
    private Composite principalComposite;
    private CompositeType topComposite = CompositeType.DATUM;
    private Button configurationButton;

    public PermissionWidget(Set<? extends ICategory> datumSet, Set<? extends ICategory> principalSet) {
        this.datumPermissionsInput = datumSet;
        this.principalPermissionsInput = principalSet;
    }

    public void setCheckedPermission(Set<PrivatePermission> checkedPermissions) {
        this.checkedPermissions = checkedPermissions;
    }

    public void setShownPermission(Set<PrivatePermission> shownPermissions) {
        this.shownPermissions = shownPermissions;
    }

    public void setTopComposite(CompositeType topComposite) {
        this.topComposite = topComposite;
    }

    public Control createContents(Composite parent) {
        this.parentShell = parent.getShell();
        this.createPermissionLabel(parent);
        this.stackComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.stackComposite);
        this.treeViewerStack = new StackLayout();
        this.stackComposite.setLayout((Layout)this.treeViewerStack);
        this.datumComposite = this.createTreeViewLayout(this.stackComposite);
        this.datumPermissionsViewer = new CheckboxTreeViewer(this.datumComposite, 2048);
        this.principalComposite = this.createTreeViewLayout(this.stackComposite);
        this.principalPermissionsViewer = new CheckboxTreeViewer(this.principalComposite, 2048);
        this.createPermssionsView(this.datumPermissionsViewer, this.datumPermissionsInput, this.principalPermissionsViewer, new DatumLabelProvider());
        this.createPermssionsView(this.principalPermissionsViewer, this.principalPermissionsInput, this.datumPermissionsViewer, new PrincipalLabelProvider());
        this.updateStackTopControl();
        this.createButtons(parent);
        Dialog.applyDialogFont((Control)parent);
        return parent;
    }

    public void dispose() {
        this.stackComposite.dispose();
    }

    private void createPermissionLabel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)composite);
        Label permissionLabel = new Label(composite, 0);
        permissionLabel.setText(Messages.LABEL_GROUP_BY);
        this.createRadioButton(composite, Messages.LABEL_INFORMATION, this.getId("groupByInformation"), CompositeType.DATUM.equals((Object)this.topComposite));
        this.createRadioButton(composite, Messages.LABEL_INTERESTED_PARTY, this.getId("groupByInterestedParty"), CompositeType.PRINCIPAL.equals((Object)this.topComposite));
    }

    private void createRadioButton(Composite parent, final String text, String id, boolean selected) {
        Button button = new Button(parent, 16);
        GridDataFactory.swtDefaults().align(1, 1).applyTo((Control)button);
        button.setText(text);
        button.setData("id", (Object)id);
        button.setSelection(selected);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PermissionWidget.this.topComposite = Messages.LABEL_INFORMATION.equals(text) ? CompositeType.DATUM : CompositeType.PRINCIPAL;
                PermissionWidget.this.updateStackTopControl();
                PermissionWidget.this.configurationButton.setEnabled(false);
            }
        });
    }

    private void createPermssionsView(final CheckboxTreeViewer sourceViewer, Set<? extends ICategory> input, final CheckboxTreeViewer targetViewer, ColumnLabelProvider labelProvider) {
        GridDataFactory.fillDefaults().hint(-1, -1).grab(true, true).applyTo(sourceViewer.getControl());
        sourceViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        sourceViewer.setContentProvider((IContentProvider)new CategoryContentProvider());
        sourceViewer.setInput(input);
        PrivacyTooltipSupport.enableFor((ColumnViewer)sourceViewer, 2);
        sourceViewer.expandAll();
        sourceViewer.setCheckedElements(this.checkedPermissions.toArray());
        this.updateAncestors(sourceViewer);
        sourceViewer.addFilter(this.getFilter());
        sourceViewer.setSorter((ViewerSorter)new PrivacySorter());
        sourceViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof ICategory) {
                    ICategory category = (ICategory)event.getElement();
                    for (PrivatePermission permission : category.getPermissions()) {
                        sourceViewer.setChecked((Object)permission, event.getChecked());
                        targetViewer.setChecked((Object)permission, event.getChecked());
                    }
                } else {
                    sourceViewer.setChecked(event.getElement(), event.getChecked());
                    targetViewer.setChecked(event.getElement(), event.getChecked());
                }
                PermissionWidget.this.updateAncestors(sourceViewer);
                PermissionWidget.this.updateAncestors(targetViewer);
            }
        });
        sourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PrivatePermission permission;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.getFirstElement() instanceof PrivatePermission && (permission = (PrivatePermission)selection.getFirstElement()).isAdvancedPreferencesSupported()) {
                    PermissionWidget.this.configurationButton.setEnabled(true);
                    return;
                }
                PermissionWidget.this.configurationButton.setEnabled(false);
            }
        });
    }

    private void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(composite);
        GridDataFactory.fillDefaults().span(4, 1).applyTo((Control)composite);
        this.createChangeAllButton(composite, Messages.BUTTON_ENABLE_ALL, this.getId("enableAll"), true);
        this.createChangeAllButton(composite, Messages.BUTTON_DISABLE_ALL, this.getId("disableAll"), false);
        this.createConfigurationButton(composite, Messages.BUTTON_CONFIGURATION, this.getId("configuration"));
    }

    private void createChangeAllButton(Composite composite, String label, String id, final boolean checkedState) {
        Button button = new Button(composite, 8);
        GridDataFactory.swtDefaults().align(1, 1).applyTo((Control)button);
        button.setText(label);
        button.setData("id", (Object)id);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                for (ICategory datum : PermissionWidget.this.datumPermissionsInput) {
                    if (datum.getPermissions().isEmpty()) continue;
                    PermissionWidget.this.datumPermissionsViewer.setSubtreeChecked((Object)datum, checkedState);
                    PermissionWidget.this.principalPermissionsViewer.setGrayed((Object)datum, false);
                }
                for (ICategory principal : PermissionWidget.this.principalPermissionsInput) {
                    PermissionWidget.this.principalPermissionsViewer.setSubtreeChecked((Object)principal, checkedState);
                    PermissionWidget.this.principalPermissionsViewer.setGrayed((Object)principal, false);
                }
                PermissionWidget.this.updateAncestors();
            }
        });
    }

    private void createConfigurationButton(Composite composite, String label, String id) {
        Label spacer = new Label(composite, 0);
        GridDataFactory.swtDefaults().grab(true, false).applyTo((Control)spacer);
        this.configurationButton = new Button(composite, 8);
        GridDataFactory.swtDefaults().align(0x1000008, 0x1000008).applyTo((Control)this.configurationButton);
        this.configurationButton.setText(label);
        this.configurationButton.setData("id", (Object)id);
        this.configurationButton.setEnabled(false);
        this.configurationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CheckboxTreeViewer viewer = CompositeType.DATUM.equals((Object)PermissionWidget.this.topComposite) ? PermissionWidget.this.datumPermissionsViewer : PermissionWidget.this.principalPermissionsViewer;
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                PrivatePermission permission = (PrivatePermission)selection.getFirstElement();
                permission.openConfigurationDialog(PermissionWidget.this.parentShell);
            }
        });
    }

    private Composite createTreeViewLayout(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        GridDataFactory.fillDefaults().applyTo((Control)composite);
        return composite;
    }

    private ViewerFilter getFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ICategory) {
                    ICategory category = (ICategory)element;
                    return !Sets.intersection((Set)PermissionWidget.this.shownPermissions, category.getPermissions()).isEmpty();
                }
                PrivatePermission privatePermission = (PrivatePermission)element;
                return PermissionWidget.this.shownPermissions.contains(privatePermission);
            }
        };
    }

    private void updateStackTopControl() {
        if (CompositeType.DATUM.equals((Object)this.topComposite)) {
            this.treeViewerStack.topControl = this.datumComposite;
        } else if (CompositeType.PRINCIPAL.equals((Object)this.topComposite)) {
            this.treeViewerStack.topControl = this.principalComposite;
        }
        this.stackComposite.layout();
    }

    private void updateAncestors(CheckboxTreeViewer viewer) {
        Set input = (Set)viewer.getInput();
        PermissionsCheckedPredicate permissionsCheckedPredicate = new PermissionsCheckedPredicate(viewer);
        for (ICategory category : input) {
            Sets.SetView permissions = Sets.intersection(this.shownPermissions, category.getPermissions());
            boolean allChecked = Iterables.all((Iterable)permissions, (Predicate)permissionsCheckedPredicate);
            boolean noneChecked = Iterables.all((Iterable)permissions, (Predicate)Predicates.not((Predicate)permissionsCheckedPredicate));
            viewer.setChecked((Object)category, !noneChecked);
            viewer.setGrayed((Object)category, !allChecked);
        }
    }

    private void updateAncestors() {
        this.updateAncestors(this.principalPermissionsViewer);
        this.updateAncestors(this.datumPermissionsViewer);
    }

    public Set<PrivatePermission> getApprovedPermissions(Set<PrivatePermission> detectedPermissions) {
        return this.getPermissions(detectedPermissions, true);
    }

    public Set<PrivatePermission> getAllApprovedPermissions() {
        return this.getPermissions(PrivacySettingsSerciveHelper.getCategoriesPermissions(this.principalPermissionsInput), true);
    }

    public Set<PrivatePermission> getDisapprovedPermissions(Set<PrivatePermission> detectedPermissions) {
        return this.getPermissions(detectedPermissions, false);
    }

    public Set<PrivatePermission> getAllDisapprovedPermissions() {
        return this.getPermissions(PrivacySettingsSerciveHelper.getCategoriesPermissions(this.principalPermissionsInput), false);
    }

    private Set<PrivatePermission> getPermissions(Set<PrivatePermission> detectedPermissions, boolean approved) {
        HashSet<PrivatePermission> permissions = new HashSet<PrivatePermission>();
        for (PrivatePermission permission : detectedPermissions) {
            if (approved != this.principalPermissionsViewer.getChecked((Object)permission)) continue;
            permissions.add(permission);
        }
        return permissions;
    }

    public void checkElements(Set<PrivatePermission> permissions) {
        for (PrivatePermission permission : permissions) {
            this.datumPermissionsViewer.setChecked((Object)permission, true);
            this.principalPermissionsViewer.setChecked((Object)permission, true);
        }
        this.updateAncestors();
    }

    private String getId(String suffix) {
        return String.valueOf(this.getClass().getName()) + '.' + suffix;
    }

    private static final class PermissionsCheckedPredicate
    implements Predicate<PrivatePermission> {
        private final CheckboxTreeViewer viewer;

        private PermissionsCheckedPredicate(CheckboxTreeViewer viewer) {
            this.viewer = viewer;
        }

        public boolean apply(PrivatePermission permission) {
            return Arrays.asList(this.viewer.getCheckedElements()).contains(permission);
        }
    }
}

