/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.privacy.rcp.widgets;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.recommenders.internal.privacy.rcp.data.ICategory;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrivatePermission;
import org.eclipse.recommenders.internal.privacy.rcp.l10n.Messages;
import org.eclipse.recommenders.internal.privacy.rcp.widgets.DatumLabelProvider;
import org.eclipse.recommenders.internal.privacy.rcp.widgets.PermissionContentProvider;
import org.eclipse.recommenders.internal.privacy.rcp.widgets.PrivacySorter;
import org.eclipse.recommenders.internal.privacy.rcp.widgets.PrivacyTooltipSupport;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class SingleDatumWidget {
    private TableViewer permissionsViewer;
    private final Set<? extends ICategory> permissionsInput;
    private final String datumId;
    private Set<PrivatePermission> checkedPermissions = Collections.emptySet();
    private Composite principalComposite;

    public SingleDatumWidget(Set<? extends ICategory> permissionSet, String datumId) {
        this.permissionsInput = permissionSet;
        this.datumId = datumId;
    }

    public void setCheckedPermissions(Set<PrivatePermission> checkedPermissions) {
        this.checkedPermissions = checkedPermissions;
    }

    public Control createContents(Composite parent) {
        this.createPermissionLabel(parent);
        this.principalComposite = this.createTreeViewLayout(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.principalComposite);
        this.permissionsViewer = new TableViewer(this.principalComposite, 2048);
        this.createPermssionsView(this.permissionsViewer, this.permissionsInput);
        this.createButtons(parent);
        Dialog.applyDialogFont((Control)parent);
        return parent;
    }

    public void refresh() {
        this.permissionsViewer.refresh();
    }

    public void dispose() {
        this.principalComposite.dispose();
    }

    private void createPermissionLabel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)composite);
        Label permissionLabel = new Label(composite, 0);
        permissionLabel.setText(Messages.LABEL_APPROVED_INTERESTED_PARTIES);
    }

    private void createPermssionsView(TableViewer sourceViewer, Set<? extends ICategory> input) {
        GridDataFactory.fillDefaults().hint(-1, -1).grab(true, true).applyTo(sourceViewer.getControl());
        sourceViewer.setLabelProvider((IBaseLabelProvider)new DatumLabelProvider());
        sourceViewer.setContentProvider((IContentProvider)new PermissionContentProvider());
        sourceViewer.setInput(this.getShownPermissions(input));
        PrivacyTooltipSupport.enableFor((ColumnViewer)sourceViewer, 2);
        sourceViewer.addFilter(this.getFilter());
        sourceViewer.setSorter((ViewerSorter)new PrivacySorter());
    }

    private void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(composite);
        GridDataFactory.fillDefaults().span(4, 1).applyTo((Control)composite);
    }

    private Composite createTreeViewLayout(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        GridDataFactory.fillDefaults().applyTo((Control)composite);
        return composite;
    }

    private ViewerFilter getFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ICategory) {
                    ICategory category = (ICategory)element;
                    return !Sets.intersection((Set)SingleDatumWidget.this.checkedPermissions, category.getPermissions()).isEmpty();
                }
                PrivatePermission privatePermission = (PrivatePermission)element;
                return SingleDatumWidget.this.checkedPermissions.contains(privatePermission);
            }
        };
    }

    private Set<PrivatePermission> getShownPermissions(Set<? extends ICategory> categorySet) {
        HashSet<PrivatePermission> permissions = new HashSet<PrivatePermission>();
        for (ICategory iCategory : categorySet) {
            for (PrivatePermission permission : iCategory.getPermissions()) {
                if (!this.datumId.equals(permission.getDatumId())) continue;
                permissions.add(permission);
            }
        }
        return permissions;
    }
}

