/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.privacy.rcp.wizards;

import com.ibm.icu.text.MessageFormat;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.recommenders.internal.privacy.rcp.l10n.Messages;
import org.eclipse.recommenders.internal.privacy.rcp.preferences.PreferencesHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class IntroPage
extends WizardPage {
    private GridDataFactory gdf;
    private GridLayoutFactory glf;

    protected IntroPage() {
        super(Messages.WIZARD_INTRO_PAGE_TITLE);
        this.setTitle(Messages.WIZARD_INTRO_PAGE_TITLE);
        this.setDescription(Messages.WIZARD_INTRO_PAGE_DESCRIPTION);
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.recommenders.privacy.rcp", (String)"icons/wizban/logo.png"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 64);
        this.glf = GridLayoutFactory.fillDefaults();
        this.glf.numColumns(2).applyTo(container);
        this.gdf = GridDataFactory.fillDefaults().grab(true, false).hint(300, -1);
        this.createDescription(container);
        this.createPreferenceLink(container);
        this.createWebsiteLink(container);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
    }

    private void createDescription(Composite parent) {
        Label label = new Label(parent, 64);
        this.gdf.applyTo((Control)label);
        label.setText(Messages.WIZARD_INTRO_PAGE_CONTENT);
    }

    private void createPreferenceLink(Composite parent) {
        Composite container = new Composite(parent, 64);
        this.glf.numColumns(1).applyTo(container);
        Link link = new Link(parent, 64);
        this.gdf.applyTo((Control)link);
        String linkToPreferencePage = PreferencesHelper.createLinkLabelToPreferencePage("org.eclipse.recommenders.privacy.rcp.preferencesPages.privacy");
        link.setText(MessageFormat.format((String)Messages.WIZARD_INTRO_PAGE_PREFS_LINK_DESCRIPTION, (Object[])new Object[]{linkToPreferencePage}));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)"org.eclipse.recommenders.privacy.rcp.preferencesPages.privacy", null, null);
                IntroPage.this.getWizard().performCancel();
                IntroPage.this.getWizard().getContainer().getShell().close();
                dialog.open();
            }
        });
    }

    private void createWebsiteLink(Composite parent) {
        Composite container = new Composite(parent, 64);
        this.glf.numColumns(1).applyTo(container);
        Link link = new Link(parent, 64);
        this.gdf.applyTo((Control)link);
        link.setText(MessageFormat.format((String)Messages.WIZARD_INTRO_PAGE_WEBSITE_LINK_DESCRIPTION, (Object[])new Object[]{Messages.WIZARD_INTRO_PAGE_LINK_URI}));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(event.text));
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

