/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.privacy.rcp.wizards;

import java.util.Set;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.recommenders.internal.privacy.rcp.data.ICategory;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrivacySettingsSerciveHelper;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrivatePermission;
import org.eclipse.recommenders.internal.privacy.rcp.l10n.Messages;
import org.eclipse.recommenders.internal.privacy.rcp.wizards.IntroPage;
import org.eclipse.recommenders.internal.privacy.rcp.wizards.PermissionApprovalPage;
import org.eclipse.recommenders.privacy.rcp.IPrivacySettingsService;

public class PermissionApprovalWizard
extends Wizard {
    private final IPrivacySettingsService service;
    private final Set<? extends ICategory> datumSet;
    private final Set<? extends ICategory> principalSet;
    private final Set<PrivatePermission> detectedPermissions;
    private PermissionApprovalPage permissionApprovalPage;

    public PermissionApprovalWizard(IPrivacySettingsService service, Set<? extends ICategory> datumSet, Set<? extends ICategory> principalSet, Set<PrivatePermission> detectedPermissions) {
        this.service = service;
        this.datumSet = datumSet;
        this.principalSet = principalSet;
        this.detectedPermissions = detectedPermissions;
    }

    public String getWindowTitle() {
        return Messages.APPROVAL_WIZARD_TITLE;
    }

    public void addPages() {
        this.addPage((IWizardPage)new IntroPage());
        this.permissionApprovalPage = new PermissionApprovalPage(this, this.datumSet, this.principalSet, this.detectedPermissions, this.loadPermissions(this.principalSet));
        this.addPage((IWizardPage)this.permissionApprovalPage);
    }

    public boolean performFinish() {
        PrivacySettingsSerciveHelper.store(this.service, this.permissionApprovalPage.getApprovedPermissions(), this.permissionApprovalPage.getDisapprovedPermissions());
        return true;
    }

    private Set<PrivatePermission> loadPermissions(Set<? extends ICategory> input) {
        return PrivacySettingsSerciveHelper.suggestApproved(this.service, input);
    }
}

