/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.privacy.rcp;

import java.util.Set;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.recommenders.internal.privacy.rcp.data.ExtensionReader;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrivacySettingsSerciveHelper;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrivatePermission;
import org.eclipse.recommenders.internal.privacy.rcp.dialogs.PermissionApprovalDialog;
import org.eclipse.recommenders.privacy.rcp.IPrivacySettingsService;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class PermissionApprovalHelper {
    private static IPrivacySettingsService settingsService;
    private static ExtensionReader extensionReader;

    static {
        BundleContext bundleContext = FrameworkUtil.getBundle(PermissionApprovalHelper.class).getBundleContext();
        IEclipseContext eclipseContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        settingsService = (IPrivacySettingsService)eclipseContext.get(IPrivacySettingsService.class);
        extensionReader = new ExtensionReader();
    }

    public static void showDefaultApprovalDialog(Shell shell, String principalId, String ... datumsIds) {
        PermissionApprovalHelper.showDialog(shell, null, null, principalId, datumsIds);
    }

    public static void showCustomApprovedDialog(Shell shell, String title, String description, String principalId, String ... datumsIds) {
        PermissionApprovalHelper.showDialog(shell, title, description, principalId, datumsIds);
    }

    private static void showDialog(Shell shell, String title, String description, String principalId, String ... datumsIds) {
        Set<PrivatePermission> permissionSet = PrivacySettingsSerciveHelper.getPermissions(PrivacySettingsSerciveHelper.getCategoriesPermissions(extensionReader.getDatumCategory()), principalId, datumsIds);
        PermissionApprovalDialog approvalDialog = new PermissionApprovalDialog(shell, settingsService, extensionReader.getDatumCategory(), extensionReader.getPrincipalCategory(), permissionSet);
        approvalDialog.setTitle(title);
        approvalDialog.setDescription(description);
        approvalDialog.open();
    }
}

