/*******************************************************************************
 * Copyright (c) 2013 Stefan Prisca.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Stefan Prisca - initial API and implementation
 ******************************************************************************/
package org.eclipse.recommenders.templates.rcp.autoedit;

import org.eclipse.jface.text.IDocument;
import org.eclipse.xtext.ui.editor.autoedit.DefaultAutoEditStrategyProvider;

import com.google.inject.Inject;

public class TemplateAutoEditStrategyProvider extends DefaultAutoEditStrategyProvider {

    @Inject
    protected TemplateMLCommentEditStrategyFactory templateMultiLineTerminals;

    @Override
    protected void configure(IEditStrategyAcceptor acceptor) {
        configureIndentationEditStrategy(acceptor);
        configureStringLiteral(acceptor);
        configureParenthesis(acceptor);
        configureSquareBrackets(acceptor);
        configureCurlyBracesBlock(acceptor);
        configureMultilineComments(acceptor);
        configureCompoundBracesBlocks(acceptor);
    }

    @Override
    protected void configureMultilineComments(IEditStrategyAcceptor acceptor) {
        acceptor.accept(singleLineTerminals.newInstance("/*", " */"), IDocument.DEFAULT_CONTENT_TYPE);
        acceptor.accept(templateMultiLineTerminals.newInstance("/*", " * ", " */"), IDocument.DEFAULT_CONTENT_TYPE);

    }

    @Override
    protected void configureStringLiteral(IEditStrategyAcceptor acceptor) {
        acceptor.accept(new TemplatePartitionInsertEditStrategy("" + '"'), IDocument.DEFAULT_CONTENT_TYPE);
        acceptor.accept(new TemplatePartitionInsertEditStrategy("'"), IDocument.DEFAULT_CONTENT_TYPE);
        acceptor.accept(partitionDeletion.newInstance("\"", "\""), IDocument.DEFAULT_CONTENT_TYPE);
        acceptor.accept(partitionDeletion.newInstance("'", "'"), IDocument.DEFAULT_CONTENT_TYPE);
        acceptor.accept(new TemplatePartitionEndSkipEditStrategy("" + '"'), IDocument.DEFAULT_CONTENT_TYPE);
        acceptor.accept(new TemplatePartitionEndSkipEditStrategy("'"), IDocument.DEFAULT_CONTENT_TYPE);
    }


    @Override
    protected void configureCurlyBracesBlock(IEditStrategyAcceptor acceptor) {
        acceptor.accept(new TemplateSingleLineTerminalEditStrategy("{", "}"), IDocument.DEFAULT_CONTENT_TYPE);
    }

}
