/*******************************************************************************
 * Copyright (c) 2013 Stefan Prisca.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Stefan Prisca - initial API and implementation
 ******************************************************************************/
package org.eclipse.recommenders.templates.rcp.autoedit;

import java.util.List;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.xtext.ui.editor.autoedit.MultiLineTerminalsEditStrategy;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

import com.google.common.collect.Lists;

public class TemplateMLCommentEditStrategy extends MultiLineTerminalsEditStrategy {

    public TemplateMLCommentEditStrategy(String leftTerminal, String indentationString, String rightTerminal) {
        super(leftTerminal, indentationString, rightTerminal);
    }

    @Override
    protected void internalCustomizeDocumentCommand(IDocument document, org.eclipse.jface.text.DocumentCommand command)
            throws BadLocationException {
        super.internalCustomizeDocumentCommand(document, command);
    }

    @Override
    protected IRegion findStartTerminal(IDocument document, int offset) throws BadLocationException {

        List<IRegion> possibleStarts = CollectionLiterals.newLinkedList();

        IRegion possibleStart = super.findStartTerminal(document, offset);

        while (possibleStart != null) {
            possibleStarts.add(possibleStart);
            possibleStart = super.findStartTerminal(document, possibleStart.getOffset());
        }

        for (IRegion start : Lists.reverse(possibleStarts)) {
            if (isValidStartRegion(start, document, offset)) {
                return start;
            }
        }
        return null;
    }

    protected boolean isValidStartRegion(IRegion possibleStart, IDocument document, int offset)
            throws BadLocationException {

        String documentText = document.get();

        IRegion stop = util.searchBackwardsInSamePartition(getRightTerminal(), documentText, document, offset);

        if (stop != null && stop.getOffset() > possibleStart.getOffset()) {
            return false;
        }

        IRegion slComment = util.searchBackwardsInSamePartition("//", document, possibleStart.getOffset());
        if (slComment != null && util.isSameLine(document, slComment.getOffset(), possibleStart.getOffset())) {
            return false;
        }

        if (isCommentInsideString(possibleStart, document)) {
            return false;
        }

        return true;
    }

    private boolean isCommentInsideString(IRegion commentStart, IDocument document) throws BadLocationException {
        int sqStringTokensBeforeComment = 0, dqStringTokensBeforeComment = 0;

        IRegion dqStringToken = util.searchBackwardsInSamePartition("\"", document, commentStart.getOffset());
        while (dqStringToken != null && util.isSameLine(document, dqStringToken.getOffset(), commentStart.getOffset())) {
            dqStringTokensBeforeComment++;
            dqStringToken = util.searchBackwardsInSamePartition("\"", document, dqStringToken.getOffset());
        }

        IRegion sqStringToken = util.searchBackwardsInSamePartition("'", document, commentStart.getOffset());
        while (sqStringToken != null && util.isSameLine(document, sqStringToken.getOffset(), commentStart.getOffset())) {
            sqStringTokensBeforeComment++;
            sqStringToken = util.searchBackwardsInSamePartition("'", document, sqStringToken.getOffset());
        }

        return dqStringTokensBeforeComment % 2 == 1 || sqStringTokensBeforeComment % 2 == 1;
    }
}
