/*******************************************************************************
 * Copyright (c) 2013 Stefan Prisca.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Stefan Prisca - initial API and implementation
 ******************************************************************************/
package org.eclipse.recommenders.templates.rcp.autoedit;

import javax.inject.Inject;

import org.eclipse.xtext.formatting.IIndentationInformation;
import org.eclipse.xtext.ui.editor.autoedit.MultiLineTerminalsEditStrategy;

import com.google.inject.MembersInjector;

public class TemplateMLCommentEditStrategyFactory {

    private final MembersInjector<MultiLineTerminalsEditStrategy> injector;
    private final IIndentationInformation indentationInformation;

    @Inject
    public TemplateMLCommentEditStrategyFactory(MembersInjector<MultiLineTerminalsEditStrategy> injector,
            IIndentationInformation indentationInformation) {
        this.injector = injector;
        this.indentationInformation = indentationInformation;
    }

    public MultiLineTerminalsEditStrategy newInstance(String leftTerminal, String indentationString,
            String rightTerminal) {
        return newInstance(leftTerminal, indentationString, rightTerminal, true);
    }

    public MultiLineTerminalsEditStrategy newInstance(String leftTerminal, String indentationString,
            String rightTerminal, boolean nested) {
        indentationString = indentationString == null ? indentationInformation.getIndentString() : indentationString;
        TemplateMLCommentEditStrategy strategy = new TemplateMLCommentEditStrategy(leftTerminal, indentationString,
                rightTerminal);
        injector.injectMembers(strategy);
        return strategy;
    }
}
