/*******************************************************************************
 * Copyright (c) 2013 Stefan Prisca.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Stefan Prisca - initial API and implementation
 ******************************************************************************/
package org.eclipse.recommenders.templates.rcp.autoedit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;

public class TemplatePartitionInsertEditStrategy extends AbstractTemplatePartitionEditStrategy {

    private final String partitionToken;

    public TemplatePartitionInsertEditStrategy(String partitionToken) {
        this.partitionToken = partitionToken;
    }

    @Override
    protected void internalCustomizeDocumentCommand(IDocument document, DocumentCommand command)
            throws BadLocationException {

        if (command.text.equals(partitionToken) && !isCommandInPartition(document, command.offset, partitionToken)) {
            insertNewPartition(command);
        }
    }

    private void insertNewPartition(DocumentCommand command) {

        command.caretOffset = command.offset + command.text.length();
        command.shiftsCaret = false;
        command.text += partitionToken;

    }

}
