/**
 * Copyright (c) 2013 Stefan Prisca.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Stefan Prisca - initial API and implementation
 */
package org.eclipse.recommenders.templates.rcp.contentassist;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.recommenders.templates.rcp.contentassist.AbstractTemplateProposalProvider;
import org.eclipse.recommenders.templates.template.Template;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

@SuppressWarnings("all")
public class TemplateProposalProvider extends AbstractTemplateProposalProvider {
  public void completeVariable_Variable(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.completeVariable_Variable(model, assignment, context, acceptor);
    final ArrayList<String> simpleVarProposals = CollectionLiterals.<String>newArrayList("array", "array_element", "array_type", "collection", "cursor", "date", 
      "dollar", "enclosing_method", "enclosing_method_arguments", "enclosing_package", "enclosing_project", 
      "enclosing_type", "exception_variable_name", "file", "index", "iterator", "iterable", "iterable_element", 
      "iterable_type", "line_selection", "primary_type_name", "return_type", "time", "todo", "user", 
      "word_selection", "year");
    for (final String proposal : simpleVarProposals) {
      ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
      acceptor.accept(_createCompletionProposal);
    }
  }
  
  public void completeFullVariable_Keyword(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    if ((!(model instanceof Template))) {
      return;
    }
    super.completeFullVariable_Keyword(model, assignment, context, acceptor);
    final ArrayList<String> fullVarProposals = CollectionLiterals.<String>newArrayList("array", "field", "var", "localVar", "argType", "elemType", "newName", 
      "newType", "import", "importStatic", "link");
    for (final String proposal : fullVarProposals) {
      ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
      acceptor.accept(_createCompletionProposal);
    }
  }
  
  public void completeText_Text(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.completeText_Text(model, assignment, context, acceptor);
    final ArrayList<String> simpleVarProposals = CollectionLiterals.<String>newArrayList("abstract", "assert", "boolean", "break", "byte", "catch", "case", "char", 
      "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", 
      "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", 
      "new", "package", "protected", "public", "private", "return", "short", "static", "strictfp", "super", 
      "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while");
    for (final String proposal : simpleVarProposals) {
      ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
      acceptor.accept(_createCompletionProposal);
    }
  }
}
