/*******************************************************************************
 * Copyright (c) 2013 Stefan Prisca.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Stefan Prisca - initial API and implementation
 ******************************************************************************/
package org.eclipse.recommenders.templates.rcp.contentassist

import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.Assignment
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher
import org.eclipse.recommenders.templates.template.Template

class TemplateProposalProvider extends AbstractTemplateProposalProvider {

    override completeVariable_Variable(EObject model, Assignment assignment, ContentAssistContext context,
        ICompletionProposalAcceptor acceptor) {

        super.completeVariable_Variable(model, assignment, context, acceptor);

        val simpleVarProposals = newArrayList("array", "array_element", "array_type", "collection", "cursor", "date",
            "dollar", "enclosing_method", "enclosing_method_arguments", "enclosing_package", "enclosing_project",
            "enclosing_type", "exception_variable_name", "file", "index", "iterator", "iterable", "iterable_element",
            "iterable_type", "line_selection", "primary_type_name", "return_type", "time", "todo", "user",
            "word_selection", "year");

        for (proposal : simpleVarProposals) {
            acceptor.accept(createCompletionProposal(proposal, context));
        }
    }

    override completeFullVariable_Keyword(EObject model, Assignment assignment, ContentAssistContext context,
        ICompletionProposalAcceptor acceptor) {

        if(! (model instanceof Template)){
            return;
        }
        super.completeFullVariable_Keyword(model, assignment, context, acceptor);

        val fullVarProposals = newArrayList("array", "field", "var", "localVar", "argType", "elemType", "newName",
            "newType", "import", "importStatic", "link");

        for (proposal : fullVarProposals) {
            acceptor.accept(createCompletionProposal(proposal, context));
        }
    }

    override completeText_Text(EObject model, Assignment assignment, ContentAssistContext context,
        ICompletionProposalAcceptor acceptor) {

        super.completeText_Text(model, assignment, context, acceptor);

        val simpleVarProposals = newArrayList("abstract", "assert", "boolean", "break", "byte", "catch", "case", "char",
            "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally",
            "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native",
            "new", "package", "protected", "public", "private", "return", "short", "static", "strictfp", "super",
            "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while");

        for (proposal : simpleVarProposals) {
            acceptor.accept(createCompletionProposal(proposal, context));
        }
    }

}
