/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.templates.rcp.autoedit;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.xtext.ui.editor.autoedit.MultiLineTerminalsEditStrategy;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

public class TemplateMLCommentEditStrategy
extends MultiLineTerminalsEditStrategy {
    public TemplateMLCommentEditStrategy(String leftTerminal, String indentationString, String rightTerminal) {
        super(leftTerminal, indentationString, rightTerminal);
    }

    protected void internalCustomizeDocumentCommand(IDocument document, DocumentCommand command) throws BadLocationException {
        super.internalCustomizeDocumentCommand(document, command);
    }

    protected IRegion findStartTerminal(IDocument document, int offset) throws BadLocationException {
        LinkedList possibleStarts = CollectionLiterals.newLinkedList((Object[])new IRegion[0]);
        IRegion possibleStart = super.findStartTerminal(document, offset);
        while (possibleStart != null) {
            possibleStarts.add(possibleStart);
            possibleStart = super.findStartTerminal(document, possibleStart.getOffset());
        }
        for (IRegion start : Lists.reverse((List)possibleStarts)) {
            if (!this.isValidStartRegion(start, document, offset)) continue;
            return start;
        }
        return null;
    }

    protected boolean isValidStartRegion(IRegion possibleStart, IDocument document, int offset) throws BadLocationException {
        String documentText = document.get();
        IRegion stop = this.util.searchBackwardsInSamePartition(this.getRightTerminal(), documentText, document, offset);
        if (stop != null && stop.getOffset() > possibleStart.getOffset()) {
            return false;
        }
        IRegion slComment = this.util.searchBackwardsInSamePartition("//", document, possibleStart.getOffset());
        if (slComment != null && this.util.isSameLine(document, slComment.getOffset(), possibleStart.getOffset())) {
            return false;
        }
        return !this.isCommentInsideString(possibleStart, document);
    }

    private boolean isCommentInsideString(IRegion commentStart, IDocument document) throws BadLocationException {
        int sqStringTokensBeforeComment = 0;
        int dqStringTokensBeforeComment = 0;
        IRegion dqStringToken = this.util.searchBackwardsInSamePartition("\"", document, commentStart.getOffset());
        while (dqStringToken != null && this.util.isSameLine(document, dqStringToken.getOffset(), commentStart.getOffset())) {
            ++dqStringTokensBeforeComment;
            dqStringToken = this.util.searchBackwardsInSamePartition("\"", document, dqStringToken.getOffset());
        }
        IRegion sqStringToken = this.util.searchBackwardsInSamePartition("'", document, commentStart.getOffset());
        while (sqStringToken != null && this.util.isSameLine(document, sqStringToken.getOffset(), commentStart.getOffset())) {
            ++sqStringTokensBeforeComment;
            sqStringToken = this.util.searchBackwardsInSamePartition("'", document, sqStringToken.getOffset());
        }
        return dqStringTokensBeforeComment % 2 == 1 || sqStringTokensBeforeComment % 2 == 1;
    }
}

