/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.templates.rcp.autoedit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.recommenders.templates.rcp.autoedit.AbstractTemplatePartitionEditStrategy;

public class TemplatePartitionEndSkipEditStrategy
extends AbstractTemplatePartitionEditStrategy {
    private final String partitionToken;

    public TemplatePartitionEndSkipEditStrategy(String partitionToken) {
        this.partitionToken = partitionToken;
    }

    protected void internalCustomizeDocumentCommand(IDocument document, DocumentCommand command) throws BadLocationException {
        if (command.length == 0 && command.text.length() > 0 && command.offset < document.getLength()) {
            String part = document.get(command.offset, this.partitionToken.length());
            if (!part.equals(this.partitionToken)) {
                return;
            }
            if (command.offset - 1 >= 0 && document.get(command.offset - 1, 1).equals("\\")) {
                return;
            }
            if (!this.isCommandInPartition(document, command.offset, this.partitionToken)) {
                return;
            }
            String cmd = command.text.substring(0, this.partitionToken.length());
            if (cmd.equals(this.partitionToken)) {
                this.skipEditPartition(command);
            }
        }
    }

    private void skipEditPartition(DocumentCommand command) {
        command.length = this.partitionToken.length();
        command.text = this.partitionToken;
    }
}

