/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.templates.rcp.syntaxhighlighting;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.eclipse.xtext.ui.editor.syntaxcoloring.AbstractAntlrTokenToAttributeIdMapper;

public class TemplatesAntlrTokenToAttributeIdMapper
extends AbstractAntlrTokenToAttributeIdMapper {
    private static final Pattern QUOTED = Pattern.compile("(?:^'([^']*)'$)|(?:^\"([^\"]*)\")$", 8);
    private static final Pattern PUNCTUATION = Pattern.compile("\\p{Punct}*");
    private static final String JAVA_RETURN_KEYWORD = "'return'";
    private static final String[] JAVA_IDENTIFIERS = new String[]{"'argType'", "'array'", "'array_element'", "'array_type'", "'collection'", "'cursor'", "'date'", "'dollar'", "'elemType'", "'enclosing_method'", "'enclosing_method_arguments'", "'enclosing_package'", "'exception_variable_name'", "'field'", "'file'", "'importStatic'", "'index'", "'iterator'", "'iterable'", "'iterable_element'", "'iterable_type'", "'line_selection'", "'link'", "'localVar'", "'newName'", "'newType'", "'primary_type_name'", "'return_type'", "'time'", "'todo'", "'user'", "'var'", "'word_selection'", "'year'"};

    protected String calculateId(String tokenName, int tokenType) {
        if (PUNCTUATION.matcher(tokenName).matches()) {
            return "punctuation";
        }
        if (QUOTED.matcher(tokenName).matches()) {
            if (Arrays.binarySearch(JAVA_IDENTIFIERS, tokenName) >= 0) {
                return "javaIdentifier";
            }
            if (tokenName.equals(JAVA_RETURN_KEYWORD)) {
                return "javaReturnKeyword";
            }
            return "keyword";
        }
        if ("RULE_SINGLE_QUOTED_STRING".equals(tokenName) || "RULE_DOUBLE_QUOTED_STRING".equals(tokenName)) {
            return "string";
        }
        if ("RULE_BINARY_NUMERAL".equals(tokenName) || "RULE_OCTAL_NUMERAL".equals(tokenName) || "RULE_DECIMAL_NUMERAL".equals(tokenName) || "RULE_HEX_NUMERAL".equals(tokenName) || "RULE_DECIMAL_FLOATING_POINT_LITERAL".equals(tokenName) || "RULE_HEXADECIMAL_FLOATING_POINT_LITERAL".equals(tokenName)) {
            return "number";
        }
        return "default";
    }
}

