/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.templates.rcp.syntaxhighlighting;

import org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlighting;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlightings;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.xtext.ui.editor.syntaxcoloring.DefaultHighlightingConfiguration;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfigurationAcceptor;
import org.eclipse.xtext.ui.editor.utils.TextStyle;

public class TemplatesHighlightingConfiguration
extends DefaultHighlightingConfiguration {
    public static final String TEMPLATE_IDENTIFIER_ID = "templateIdentifier";
    public static final String TEMPLATE_KEYWORD_ID = "templateKeyword";
    public static final String TEMPLATE_SPECIAL_TYPE_ID = "templateSpecialType";
    public static final String JAVA_IDENTIFIER_ID = "javaIdentifier";
    public static final String JAVA_MULTI_LINE_COMMENT_ID = "javaMultiLineComment";
    public static final String JAVA_SINGLE_LINE_COMMENT_ID = "javaSingleLineComment";
    public static final String JAVA_BRACKETS_ID = "javaBrackets";
    public static final String JAVA_OPERATOR_ID = "javaOperator";
    public static final String JAVA_RETURN_KEYWORD_ID = "javaReturnKeyword";
    private final IPreferenceStore jdtPrefs = PreferenceConstants.getPreferenceStore();
    private final IColorManager colorMan = new JavaTextTools(this.jdtPrefs).getColorManager();

    public void configure(IHighlightingConfigurationAcceptor acceptor) {
        acceptor.acceptDefaultHighlighting(TEMPLATE_IDENTIFIER_ID, "Template Identifier", this.templateIdentifierTextStyle());
        acceptor.acceptDefaultHighlighting(TEMPLATE_KEYWORD_ID, "Template Keyword", this.templateKeywordTextStyle());
        acceptor.acceptDefaultHighlighting(TEMPLATE_SPECIAL_TYPE_ID, "Template Special Type", this.templateSpecialTypeTextStyle());
        acceptor.acceptDefaultHighlighting(JAVA_IDENTIFIER_ID, "Java Identifier", this.defaultTextStyle());
        acceptor.acceptDefaultHighlighting(JAVA_MULTI_LINE_COMMENT_ID, "Multi Line Comment", this.javaMultiLineCommentTextStyle());
        acceptor.acceptDefaultHighlighting(JAVA_SINGLE_LINE_COMMENT_ID, "Single Line Comment", this.javaSingleLineCommentTextStyle());
        acceptor.acceptDefaultHighlighting(JAVA_BRACKETS_ID, "Brackets", this.javaBracketsTextStyle());
        acceptor.acceptDefaultHighlighting(JAVA_OPERATOR_ID, "Operator", this.javaOperatorTextStyle());
        acceptor.acceptDefaultHighlighting(JAVA_RETURN_KEYWORD_ID, "Keyword 'return'", this.javaReturnKeywordTextStyle());
        acceptor.acceptDefaultHighlighting("keyword", "Keywords excluding 'return'", this.keywordTextStyle());
        acceptor.acceptDefaultHighlighting("task", "Task Tag", this.taskTextStyle());
        acceptor.acceptDefaultHighlighting("string", "String", this.stringTextStyle());
        acceptor.acceptDefaultHighlighting("number", "Number", this.numberTextStyle());
        acceptor.acceptDefaultHighlighting("default", "Default", this.defaultTextStyle());
        acceptor.acceptDefaultHighlighting("error", "Invalid Symbol", this.errorTextStyle());
    }

    protected TextStyle templateSpecialTypeTextStyle() {
        TextStyle style = this.defaultTextStyle().copy();
        style.setColor(new RGB(155, 0, 0));
        style.setStyle(2);
        return style;
    }

    protected TextStyle templateIdentifierTextStyle() {
        TextStyle style = this.defaultTextStyle().copy();
        style.setColor(new RGB(255, 128, 64));
        return style;
    }

    protected TextStyle templateKeywordTextStyle() {
        TextStyle style = this.defaultTextStyle().copy();
        style.setColor(new RGB(64, 0, 128));
        style.setStyle(1);
        return style;
    }

    protected TextStyle javaMultiLineCommentTextStyle() {
        if (!SemanticHighlightings.isEnabled((IPreferenceStore)this.jdtPrefs)) {
            return super.commentTextStyle();
        }
        TextStyle mlCommentTextStyle = this.defaultTextStyle();
        mlCommentTextStyle.setStyle(this.getJDTStyle("java_multi_line_comment_bold", "java_multi_line_comment_italic", "java_multi_line_comment_underline"));
        mlCommentTextStyle.setColor(this.colorMan.getColor("java_multi_line_comment").getRGB());
        return mlCommentTextStyle;
    }

    protected TextStyle javaSingleLineCommentTextStyle() {
        if (!SemanticHighlightings.isEnabled((IPreferenceStore)this.jdtPrefs)) {
            return super.commentTextStyle();
        }
        TextStyle slCommentTextStyle = this.defaultTextStyle();
        slCommentTextStyle.setStyle(this.getJDTStyle("java_single_line_comment_bold", "java_single_line_comment_italic", "java_single_line_comment_underline"));
        slCommentTextStyle.setColor(this.colorMan.getColor("java_single_line_comment").getRGB());
        return slCommentTextStyle;
    }

    protected TextStyle javaOperatorTextStyle() {
        if (!SemanticHighlightings.isEnabled((IPreferenceStore)this.jdtPrefs)) {
            return super.defaultTextStyle();
        }
        TextStyle operatorTextStyle = this.defaultTextStyle();
        operatorTextStyle.setStyle(this.getJDTStyle("java_operator_bold", "java_operator_italic", "java_operator_underline"));
        operatorTextStyle.setColor(this.colorMan.getColor("java_operator").getRGB());
        return operatorTextStyle;
    }

    protected TextStyle javaBracketsTextStyle() {
        if (!SemanticHighlightings.isEnabled((IPreferenceStore)this.jdtPrefs)) {
            return super.defaultTextStyle();
        }
        TextStyle bracketsTextStyle = this.defaultTextStyle();
        bracketsTextStyle.setStyle(this.getJDTStyle("java_bracket_bold", "java_bracket_italic", "java_bracket_underline"));
        bracketsTextStyle.setColor(this.colorMan.getColor("java_bracket").getRGB());
        return bracketsTextStyle;
    }

    protected TextStyle javaReturnKeywordTextStyle() {
        if (!SemanticHighlightings.isEnabled((IPreferenceStore)this.jdtPrefs)) {
            return super.defaultTextStyle();
        }
        TextStyle returnKeywordTextStyle = this.defaultTextStyle();
        returnKeywordTextStyle.setStyle(this.getJDTStyle("java_keyword_return_bold", "java_keyword_return_italic", "java_keyword_return_underline"));
        returnKeywordTextStyle.setColor(this.colorMan.getColor("java_keyword_return").getRGB());
        return returnKeywordTextStyle;
    }

    public TextStyle keywordTextStyle() {
        if (!SemanticHighlightings.isEnabled((IPreferenceStore)this.jdtPrefs)) {
            return super.keywordTextStyle();
        }
        TextStyle javaKeywordStyle = this.defaultTextStyle();
        javaKeywordStyle.setStyle(this.getJDTStyle("java_keyword_bold", "java_keyword_italic", "java_keyword_underline"));
        javaKeywordStyle.setColor(this.colorMan.getColor("java_keyword").getRGB());
        return javaKeywordStyle;
    }

    public TextStyle taskTextStyle() {
        if (!SemanticHighlightings.isEnabled((IPreferenceStore)this.jdtPrefs)) {
            return super.taskTextStyle();
        }
        TextStyle taskTextStyle = this.defaultTextStyle();
        taskTextStyle.setStyle(this.getJDTStyle("java_comment_task_tag_bold", "java_comment_task_tag_italic", "java_comment_task_tag_underline"));
        taskTextStyle.setColor(this.colorMan.getColor("java_comment_task_tag").getRGB());
        return taskTextStyle;
    }

    public TextStyle stringTextStyle() {
        if (!SemanticHighlightings.isEnabled((IPreferenceStore)this.jdtPrefs)) {
            return super.stringTextStyle();
        }
        TextStyle stringTextStyle = this.defaultTextStyle();
        stringTextStyle.setStyle(this.getJDTStyle("java_string_bold", "java_string_italic", "java_string_underline"));
        stringTextStyle.setColor(this.colorMan.getColor("java_string").getRGB());
        return stringTextStyle;
    }

    public TextStyle numberTextStyle() {
        if (!SemanticHighlightings.isEnabled((IPreferenceStore)this.jdtPrefs)) {
            return super.numberTextStyle();
        }
        TextStyle numberTextStyle = this.defaultTextStyle();
        numberTextStyle.setStyle(this.getJDTStyle("number"));
        RGB color = this.getJDTStyleColor("number");
        numberTextStyle.setColor(color != null ? color : super.numberTextStyle().getColor());
        return numberTextStyle;
    }

    public TextStyle defaultTextStyle() {
        if (!SemanticHighlightings.isEnabled((IPreferenceStore)this.jdtPrefs)) {
            return super.defaultTextStyle();
        }
        TextStyle defaultTextStyle = super.defaultTextStyle();
        defaultTextStyle.setStyle(this.getJDTStyle("java_default_bold", "java_default_italic", "java_default_underline"));
        RGB color = this.colorMan.getColor("java_default").getRGB();
        defaultTextStyle.setColor(color);
        return defaultTextStyle;
    }

    private RGB getJDTStyleColor(String highlightKey) {
        SemanticHighlighting h = this.getSemHighlight(highlightKey);
        if (h == null) {
            return null;
        }
        RGB color = super.numberTextStyle().getColor();
        String enabledKey = SemanticHighlightings.getEnabledPreferenceKey((SemanticHighlighting)h);
        if (this.jdtPrefs.getBoolean(enabledKey)) {
            color = PreferenceConverter.getColor((IPreferenceStore)this.jdtPrefs, (String)SemanticHighlightings.getColorPreferenceKey((SemanticHighlighting)h));
        }
        return color;
    }

    private int getJDTStyle(String semHighlightId) {
        int style = 0;
        SemanticHighlighting h = this.getSemHighlight(semHighlightId);
        if (h == null) {
            return style;
        }
        String enabledKey = SemanticHighlightings.getEnabledPreferenceKey((SemanticHighlighting)h);
        if (this.jdtPrefs.getBoolean(enabledKey)) {
            style = this.getJDTStyle(SemanticHighlightings.getBoldPreferenceKey((SemanticHighlighting)h), SemanticHighlightings.getItalicPreferenceKey((SemanticHighlighting)h), SemanticHighlightings.getUnderlinePreferenceKey((SemanticHighlighting)h));
        }
        return style;
    }

    private int getJDTStyle(String bold, String italic, String underline) {
        int style = 0;
        if (this.jdtPrefs.getBoolean(bold)) {
            style |= 1;
        }
        if (this.jdtPrefs.getBoolean(italic)) {
            style |= 2;
        }
        if (this.jdtPrefs.getBoolean(underline)) {
            style |= 0x40000000;
        }
        return style;
    }

    private SemanticHighlighting getSemHighlight(String key) {
        SemanticHighlighting[] highlights;
        SemanticHighlighting[] semanticHighlightingArray = highlights = SemanticHighlightings.getSemanticHighlightings();
        int n = highlights.length;
        int n2 = 0;
        while (n2 < n) {
            SemanticHighlighting h = semanticHighlightingArray[n2];
            if (h.getPreferenceKey().equals(key)) {
                return h;
            }
            ++n2;
        }
        return null;
    }
}

