/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.templates.rcp.syntaxhighlighting;

import javax.inject.Inject;
import org.eclipse.recommenders.templates.services.TemplateGrammarAccess;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator;

public class TemplatesSemanticHighlightingCalculator
implements ISemanticHighlightingCalculator {
    private final TemplateGrammarAccess grammar;

    @Inject
    public TemplatesSemanticHighlightingCalculator(TemplateGrammarAccess grammar) {
        this.grammar = grammar;
    }

    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        if (resource == null || resource.getParseResult() == null) {
            return;
        }
        int slCommentLine = -1;
        int slCommentOffset = -1;
        int mlCommentStartOffset = -1;
        int stringStartOffset = -1;
        int stringEndOffset = -1;
        int stringStartLine = -1;
        String stringType = null;
        ICompositeNode root = resource.getParseResult().getRootNode();
        int mlCommentEndOffset = stringEndOffset = root.getTotalEndOffset() + 1;
        for (INode node : root.getAsTreeIterable()) {
            if (this.isDerived(node, new AbstractRule[]{this.grammar.getIDRule(), this.grammar.getTemplateIdentifierRule()}) || this.isDerived(node, new AbstractRule[]{this.grammar.getJavaKeywordRule(), this.grammar.getTemplateIdentifierRule()}) || this.isTemplateKeywordDerivedFrom(node, (AbstractRule)this.grammar.getTemplateIdentifierRule()) || this.isDerived(node, new AbstractRule[]{this.grammar.getSimpleVariableRule(), this.grammar.getTemplateIdentifierRule(), this.grammar.getFullVariableRule()})) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"templateIdentifier"});
                continue;
            }
            if (this.isDerived(node, new AbstractRule[]{this.grammar.getSimpleVariableRule()}) && !this.isDerived(node, new AbstractRule[]{this.grammar.getSimpleVariableRule(), this.grammar.getTemplateIdentifierRule(), this.grammar.getFullVariableRule()}) && !this.isDerived(node, new AbstractRule[]{this.grammar.getSimpleVariableRule(), this.grammar.getTemplateIdentifierRule(), this.grammar.getQualifiedNameRule()})) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"templateKeyword"});
                continue;
            }
            if (this.isDerived(node, new AbstractRule[]{this.grammar.getTypeRule(), this.grammar.getFullVariableRule()})) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"templateSpecialType"});
                continue;
            }
            if (this.isTemplateKeywordDerivedFrom(node, (AbstractRule)this.grammar.getFullVariableRule()) && !this.isTemplateKeywordDerivedFrom(node, (AbstractRule)this.grammar.getQualifiedNameRule())) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"templateKeyword"});
                continue;
            }
            if (this.isDerived(node, new AbstractRule[]{this.grammar.getTemplateSingleQuotedStringRule(), this.grammar.getProposalRule()})) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"string"});
                continue;
            }
            if (this.isDerived(node, new AbstractRule[]{this.grammar.getSingleQuotedStringRule()}) && (stringType == null || node.getStartLine() != stringStartLine) && !this.isStringInComment(node, slCommentOffset, slCommentLine, mlCommentStartOffset, mlCommentEndOffset)) {
                stringStartOffset = node.getOffset();
                stringStartLine = node.getStartLine();
                stringEndOffset = root.getTotalEndOffset() + 1;
                stringType = this.grammar.getSingleQuotedStringRule().getName();
                continue;
            }
            if (this.isDerived(node, new AbstractRule[]{this.grammar.getSingleQuotedStringRule()}) && stringType == this.grammar.getSingleQuotedStringRule().getName()) {
                stringEndOffset = node.getEndOffset();
                stringType = null;
                continue;
            }
            if (this.isDerived(node, new AbstractRule[]{this.grammar.getDoubleQuotedStringRule()}) && (stringType == null || node.getStartLine() != stringStartLine) && !this.isStringInComment(node, slCommentOffset, slCommentLine, mlCommentStartOffset, mlCommentEndOffset)) {
                stringStartOffset = node.getOffset();
                stringStartLine = node.getStartLine();
                stringEndOffset = root.getTotalEndOffset() + 1;
                stringType = this.grammar.getDoubleQuotedStringRule().getName();
                continue;
            }
            if (this.isDerived(node, new AbstractRule[]{this.grammar.getDoubleQuotedStringRule()}) && stringType == this.grammar.getDoubleQuotedStringRule().getName()) {
                stringEndOffset = node.getEndOffset();
                stringType = null;
                continue;
            }
            if (stringType != null && node.getStartLine() == stringStartLine && node.getOffset() >= stringStartOffset && node.getOffset() - 1 <= stringEndOffset && this.hasAncestor(node, (AbstractRule)this.grammar.getTextRule())) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"string"});
                continue;
            }
            if (this.isDerived(node, new AbstractRule[]{this.grammar.getSlCommentRule()}) && !this.isCommentInString(stringStartOffset, node.getOffset(), node.getStartLine(), stringStartLine, stringType != null)) {
                slCommentLine = node.getStartLine();
                slCommentOffset = node.getOffset();
                continue;
            }
            if (this.isDerived(node, new AbstractRule[]{this.grammar.getMlCommentStartRule()}) && !this.isCommentInString(stringStartOffset, node.getOffset(), node.getStartLine(), stringStartLine, stringType != null) && !this.isMlCommentInSlComment(node.getStartLine(), slCommentLine, node.getOffset(), slCommentOffset)) {
                mlCommentStartOffset = node.getOffset();
                mlCommentEndOffset = root.getTotalEndOffset() + 1;
                continue;
            }
            if (this.isDerived(node, new AbstractRule[]{this.grammar.getMlCommentEndRule()})) {
                mlCommentEndOffset = node.getEndOffset();
                mlCommentStartOffset = -1;
                continue;
            }
            if (node.getStartLine() == slCommentLine && this.hasAncestor(node, (AbstractRule)this.grammar.getTextRule())) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"javaSingleLineComment"});
                continue;
            }
            if (mlCommentStartOffset >= 0 && node.getOffset() >= mlCommentStartOffset && node.getEndOffset() <= mlCommentEndOffset && this.hasAncestor(node, (AbstractRule)this.grammar.getTextRule())) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"javaMultiLineComment"});
                continue;
            }
            if (this.isDerived(node, new AbstractRule[]{this.grammar.getJavaBracketsRule()})) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"javaBrackets"});
                continue;
            }
            if (!this.isDerived(node, new AbstractRule[]{this.grammar.getJavaOperatorRule()})) continue;
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"javaOperator"});
        }
    }

    private boolean isMlCommentInSlComment(int startLine, int slCommentLine, int offset, int slCommentOffset) {
        return startLine == slCommentLine && offset > slCommentOffset;
    }

    private boolean isStringInComment(INode stringNode, int slCommentOffset, int slCommentLine, int mlCommentStartOffset, int mlCommentEndOffset) {
        int stringOffset = stringNode.getOffset();
        int stringLine = stringNode.getStartLine();
        return slCommentOffset >= 0 && stringLine == slCommentLine && stringOffset > slCommentOffset || mlCommentStartOffset >= 0 && stringOffset > mlCommentStartOffset && stringOffset < mlCommentEndOffset;
    }

    private boolean isCommentInString(int stringStartOffset, int commentStartOffset, int commentStartLine, int stringStartLine, boolean openString) {
        return openString && commentStartOffset > stringStartOffset && commentStartLine == stringStartLine;
    }

    private boolean isTemplateKeywordDerivedFrom(INode node, AbstractRule ancestors) {
        return this.isDerived(node, new AbstractRule[]{this.grammar.getFieldTemplateKeywordRule(), ancestors}) || this.isDerived(node, new AbstractRule[]{this.grammar.getVarTemplateKeywordRule(), ancestors}) || this.isDerived(node, new AbstractRule[]{this.grammar.getLocalVarTemplateKeywordRule(), ancestors}) || this.isDerived(node, new AbstractRule[]{this.grammar.getArgTypeTemplateKeywordRule(), ancestors}) || this.isDerived(node, new AbstractRule[]{this.grammar.getElemTypeTemplateKeywordRule(), ancestors}) || this.isDerived(node, new AbstractRule[]{this.grammar.getNewNameTemplateKeywordRule(), ancestors}) || this.isDerived(node, new AbstractRule[]{this.grammar.getNewTypeTemplateKeywordRule(), ancestors}) || this.isDerived(node, new AbstractRule[]{this.grammar.getImportTemplateKeywordRule(), ancestors}) || this.isDerived(node, new AbstractRule[]{this.grammar.getImportStaticTemplateKeywordRule(), ancestors}) || this.isDerived(node, new AbstractRule[]{this.grammar.getLinkTemplateKeywordRule(), ancestors}) || this.isDerived(node, new AbstractRule[]{this.grammar.getArrayTemplateKeywordRule(), ancestors});
    }

    private boolean isDerived(INode node, AbstractRule ... ancestorRules) {
        int i = 0;
        while (i < ancestorRules.length) {
            if (node == null || !(node.getGrammarElement() instanceof RuleCall)) {
                return false;
            }
            AbstractRule ancestorNodeRule = ((RuleCall)node.getGrammarElement()).getRule();
            if (!ancestorNodeRule.getName().equals(ancestorRules[i].getName())) {
                return false;
            }
            node = node.getParent();
            ++i;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean hasAncestor(INode node, AbstractRule ancestorRule) {
        if (node != null) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (node.getGrammarElement() instanceof RuleCall && (ancestorNodeRule = ((RuleCall)node.getGrammarElement()).getRule()).getName().equals(ancestorRule.getName())) {
                return true;
            }
            node = node.getParent();
lbl6:
            // 2 sources

            ** while (node != null)
        }
lbl7:
        // 1 sources

        return false;
    }
}

