/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.templates.snipmatch.rcp;

import com.google.inject.Injector;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.snipmatch.Snippet;
import org.eclipse.recommenders.snipmatch.rcp.SnippetEditorInput;
import org.eclipse.recommenders.templates.rcp.internal.TemplateActivator;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;

public class SnippetSourcePage
extends FormPage {
    private ISnippet snippet;
    private AbstractFormPart codePart;
    private EmbeddedEditor handle;

    public SnippetSourcePage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        form.setText(this.getTitle());
        Composite body = form.getBody();
        toolkit.decorateFormHeading(form.getForm());
        toolkit.paintBordersFor(body);
        managedForm.getForm().getBody().setLayout((Layout)new GridLayout());
        this.codePart = new CodePart();
        managedForm.addPart((IFormPart)this.codePart);
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.snippet = ((SnippetEditorInput)input).getSnippet();
        this.getEditor().addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (propId == 258) {
                    SnippetSourcePage.this.getManagedForm().removePart((IFormPart)SnippetSourcePage.this.codePart);
                    SnippetSourcePage.this.codePart.dispose();
                    SnippetSourcePage.this.snippet = (ISnippet)((SnippetEditorInput)SnippetSourcePage.this.getEditor().getEditorInput()).getSnippet();
                    SnippetSourcePage.this.codePart = new CodePart();
                    SnippetSourcePage.this.getManagedForm().addPart((IFormPart)SnippetSourcePage.this.codePart);
                }
            }
        });
        super.init(site, input);
    }

    class CodePart
    extends AbstractFormPart {
        IObservableValue snippetBeanCode;

        CodePart() {
        }

        public void initialize(IManagedForm form) {
            super.initialize(form);
            form.getForm().getBody().setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, true));
            TemplateActivator activator = TemplateActivator.getInstance();
            final Injector injector = activator.getInjector("org.eclipse.recommenders.templates.Template");
            IEditedResourceProvider resourceProvider = new IEditedResourceProvider(){

                public XtextResource createResource() {
                    IResourceFactory resourceFactory = (IResourceFactory)injector.getInstance(IResourceFactory.class);
                    URI uri = URI.createURI((String)("x-uuid:" + SnippetSourcePage.this.snippet.getUuid().toString()));
                    XtextResourceSet rs = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
                    rs.setClasspathURIContext(this.getClass());
                    Resource resource = resourceFactory.createResource(uri);
                    rs.getResources().add((Object)resource);
                    return (XtextResource)resource;
                }
            };
            EmbeddedEditorFactory factory = (EmbeddedEditorFactory)injector.getInstance(EmbeddedEditorFactory.class);
            SnippetSourcePage.this.handle = factory.newEditor(resourceProvider).showErrorAndWarningAnnotations().withParent(form.getForm().getBody());
            SnippetSourcePage.this.handle.createPartialEditor(true);
            SnippetSourcePage.this.handle.getDocument().set(SnippetSourcePage.this.snippet.getCode());
            SnippetSourcePage.this.handle.getDocument().addDocumentListener(new IDocumentListener(){

                public void documentChanged(DocumentEvent event) {
                    String code = event.getDocument().get();
                    ((Snippet)SnippetSourcePage.this.snippet).setCode(code);
                }

                public void documentAboutToBeChanged(DocumentEvent event) {
                }
            });
            this.snippetBeanCode = BeanProperties.value(Snippet.class, (String)"code", String.class).observe((Object)SnippetSourcePage.this.snippet);
            this.snippetBeanCode.addChangeListener(new IChangeListener(){

                public void handleChange(ChangeEvent event) {
                    if (!SnippetSourcePage.this.handle.getDocument().get().equals(SnippetSourcePage.this.snippet.getCode())) {
                        CodePart.this.markStale();
                    } else {
                        CodePart.this.markDirty();
                    }
                }
            });
        }

        public void dispose() {
            this.snippetBeanCode.dispose();
            SnippetSourcePage.this.handle.getViewer().getControl().dispose();
            super.dispose();
        }

        public void updateInput() {
        }

        public void commit(boolean onSave) {
            if (onSave) {
                super.commit(onSave);
            }
        }

        public void refresh() {
            SnippetSourcePage.this.handle.getDocument().set(SnippetSourcePage.this.snippet.getCode());
            super.refresh();
        }
    }
}

