/*******************************************************************************
 * Copyright (c) 2013 Stefan Prisca.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Stefan Prisca - initial API and implementation
 ******************************************************************************/

package org.eclipse.recommenders.templates.validation;

import java.util.Map;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.recommenders.templates.template.Escape;
import org.eclipse.recommenders.templates.template.FullVariable;
import org.eclipse.recommenders.templates.template.Template;
import org.eclipse.recommenders.templates.template.TemplatePackage;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

@SuppressWarnings("all")
public class TemplateJavaValidator extends AbstractTemplateJavaValidator {

    @Check
    public void checkUniqueVariables(Template template) {

        Map<String, EList<String>> variableIdToArgMapping = CollectionLiterals.newLinkedHashMap();
        Map<String, String> variableIdToKeywordMapping = CollectionLiterals.newLinkedHashMap();

        for (EObject object : template.getElements()) {
            if (object instanceof Escape && ((Escape) object).getVariable() instanceof FullVariable) {
                FullVariable variable = (FullVariable) ((Escape) object).getVariable();
                assertUniqueTemplateVariable(variable, variableIdToArgMapping, variableIdToKeywordMapping);
            }
        }
    }

    public void assertUniqueTemplateVariable(FullVariable variable, Map<String, EList<String>> variableIdToArgMapping,
            Map<String, String> variableIdToKeywordMapping) {

        String variableId = variable.getId();

        EList<String> variableArgs = variable.getArguments();

        if (variableIdToArgMapping.containsKey(variableId)
                && !variableIdToArgMapping.get(variableId).equals(variableArgs)) {

            acceptError("Template variable '" + variableId + "' has incompatible types", variable,
                    TemplatePackage.Literals.FULL_VARIABLE__ARGUMENTS,
                    getErrorIndex(variableIdToArgMapping.get(variableId), variableArgs), "101");

        } else if (!variableIdToArgMapping.containsKey(variableId)) {

            variableIdToArgMapping.put(variableId, variableArgs);

        }

        String variableKeyword = variable.getKeyword();

        if (variableIdToKeywordMapping.containsKey(variableId)
                && !variableIdToKeywordMapping.get(variableId).equals(variableKeyword)) {

            acceptError("Template variable '" + variableId + "' has incompatible types", variable,
                    TemplatePackage.Literals.FULL_VARIABLE__KEYWORD, -1, "102");

        } else if (!variableIdToKeywordMapping.containsKey(variableId)) {

            variableIdToKeywordMapping.put(variableId, variableKeyword);

        }

    }

    private int getErrorIndex(EList<String> eList, EList<String> variableArgs) {
        for (String s : variableArgs) {
            if (!eList.contains(s)) {
                return variableArgs.indexOf(s);
            }
        }
        return -1;
    }
}
