/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.quickfix;

import com.google.inject.Inject;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.ui.editor.quickfix.XtextQuickAssistProcessor;

public class XtextQuickAssistAssistant
extends QuickAssistAssistant {
    protected ISourceViewer viewer;
    protected Position storedPosition;

    @Inject
    public XtextQuickAssistAssistant(XtextQuickAssistProcessor processor) {
        this.setQuickAssistProcessor(processor);
        this.setInformationControlCreator((IInformationControlCreator)this.createInformationControlCreator());
        this.setRestoreSelection();
    }

    protected void setRestoreSelection() {
        this.addCompletionListener(new ICompletionListener(){

            public void assistSessionStarted(ContentAssistEvent event) {
                Point selectedRange = XtextQuickAssistAssistant.this.viewer.getSelectedRange();
                XtextQuickAssistAssistant.this.storePosition(selectedRange.x, selectedRange.y);
            }

            public void assistSessionEnded(ContentAssistEvent event) {
                XtextQuickAssistAssistant.this.restorePosition();
            }

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }
        });
    }

    protected AbstractReusableInformationControlCreator createInformationControlCreator() {
        return new AbstractReusableInformationControlCreator(){

            public IInformationControl doCreateInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, null);
            }
        };
    }

    public void install(ISourceViewer sourceViewer) {
        super.install(sourceViewer);
        this.viewer = sourceViewer;
    }

    public void uninstall() {
        this.viewer = null;
        super.uninstall();
    }

    private void restorePosition() {
        if (this.storedPosition != null && !this.storedPosition.isDeleted() && this.viewer.getDocument() != null) {
            this.viewer.setSelectedRange(this.storedPosition.offset, this.storedPosition.length);
            this.viewer.revealRange(this.storedPosition.offset, this.storedPosition.length);
        }
        this.storedPosition = null;
    }

    private void storePosition(int currOffset, int currLength) {
        this.storedPosition = new Position(currOffset, currLength);
    }
}

