/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.ui.refactoring.JdtRenameRefactoringProcessorFactory;
import org.eclipse.xtext.common.types.ui.refactoring.participant.JdtRenameParticipant;
import org.eclipse.xtext.ui.refactoring.impl.RenameElementProcessor;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt.CombinedJvmJdtRenameContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedJvmJdtRenameProcessor
extends RenameElementProcessor {
    @Inject
    private JdtRenameRefactoringProcessorFactory jdtRefactoringFactory;
    private Map<URI, JavaRenameProcessor> jvmElements2jdtProcessors;

    public boolean initialize(IRenameElementContext renameElementContext) {
        Assert.isLegal((boolean)(renameElementContext instanceof CombinedJvmJdtRenameContext));
        if (!super.initialize(renameElementContext)) {
            return false;
        }
        this.jvmElements2jdtProcessors = Maps.newHashMap();
        for (Map.Entry<URI, IJavaElement> jvm2javaElement : ((CombinedJvmJdtRenameContext)renameElementContext).getJvm2JavaElements().entrySet()) {
            JavaRenameProcessor jdtRenameProcessor = this.jdtRefactoringFactory.createRenameProcessor(jvm2javaElement.getValue());
            if (jdtRenameProcessor != null) {
                this.jvmElements2jdtProcessors.put(jvm2javaElement.getKey(), jdtRenameProcessor);
                continue;
            }
            return false;
        }
        return true;
    }

    public Object[] getElements() {
        ArrayList elements = Lists.newArrayList((Object[])super.getElements());
        for (JavaRenameProcessor jdtProcessor : this.jvmElements2jdtProcessors.values()) {
            Object[] objectArray = jdtProcessor.getElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                elements.add(element);
                ++n2;
            }
        }
        return Iterables.toArray((Iterable)elements, Object.class);
    }

    public String getProcessorName() {
        return "Rename element and inferred Java artifacts";
    }

    protected Iterable<JavaRenameProcessor> getSubProcessors() {
        return this.jvmElements2jdtProcessors.values();
    }

    public boolean isApplicable() throws CoreException {
        if (!super.isApplicable()) {
            return false;
        }
        for (JavaRenameProcessor processor : this.jvmElements2jdtProcessors.values()) {
            if (processor.isApplicable()) continue;
            return false;
        }
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pm, (int)(this.jvmElements2jdtProcessors.size() + 1));
        RefactoringStatus status = super.checkInitialConditions((IProgressMonitor)monitor.newChild(1));
        for (JavaRenameProcessor processor : this.jvmElements2jdtProcessors.values()) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            status.merge(processor.checkInitialConditions((IProgressMonitor)monitor.newChild(1)));
        }
        return status;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pm, (int)(this.jvmElements2jdtProcessors.size() + 1));
        RefactoringStatus status = super.checkFinalConditions((IProgressMonitor)monitor.newChild(1), context);
        ResourceSet resourceSet = this.getResourceSet(this.getRenameElementContext());
        this.getRenameArguments().getRenameStrategy().applyDeclarationChange(this.getNewName(), resourceSet);
        for (Map.Entry<URI, JavaRenameProcessor> jvmElement2jdtRefactoring : this.jvmElements2jdtProcessors.entrySet()) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            URI renamedJvmElementURI = this.getRenameArguments().getNewElementURI(jvmElement2jdtRefactoring.getKey());
            EObject renamedJvmElement = resourceSet.getEObject(renamedJvmElementURI, false);
            if (!(renamedJvmElement instanceof JvmIdentifiableElement) || renamedJvmElement.eIsProxy()) {
                status.addError("Cannot find inferred JVM element after refactoring.");
                continue;
            }
            JavaRenameProcessor jdtRefactoring = jvmElement2jdtRefactoring.getValue();
            jdtRefactoring.setNewElementName(((JvmIdentifiableElement)renamedJvmElement).getSimpleName());
            status.merge(jdtRefactoring.checkFinalConditions((IProgressMonitor)monitor.newChild(1), context));
        }
        this.getRenameArguments().getRenameStrategy().revertDeclarationChange(resourceSet);
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pm, (int)(this.jvmElements2jdtProcessors.size() + 1));
        CompositeChange compositeChange = new CompositeChange(this.getProcessorName());
        compositeChange.add(super.createChange((IProgressMonitor)monitor.newChild(1)));
        for (JavaRenameProcessor processor : this.jvmElements2jdtProcessors.values()) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            compositeChange.add(processor.createChange((IProgressMonitor)monitor.newChild(1)));
        }
        return compositeChange;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        ArrayList participants = Lists.newArrayList((Object[])super.loadParticipants(status, sharedParticipants));
        for (JavaRenameProcessor processor : this.jvmElements2jdtProcessors.values()) {
            RefactoringParticipant[] refactoringParticipantArray = processor.loadParticipants(status, sharedParticipants);
            int n = refactoringParticipantArray.length;
            int n2 = 0;
            while (n2 < n) {
                RefactoringParticipant participant = refactoringParticipantArray[n2];
                if (participant instanceof JdtRenameParticipant) {
                    ((JdtRenameParticipant)participant).disableFor(this.getElements());
                }
                participants.add(participant);
                ++n2;
            }
        }
        return (RefactoringParticipant[])Iterables.toArray((Iterable)participants, RefactoringParticipant.class);
    }
}

