/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.AbstractCompoundSelectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class ResourceDescriptionsData
extends AbstractCompoundSelectable {
    private final Map<URI, IResourceDescription> resourceDescriptionMap;
    private final Map<QualifiedName, Object> lookupMap;

    public ResourceDescriptionsData(Iterable<IResourceDescription> descriptions) {
        int expectedSize = 500;
        if (descriptions instanceof Collection) {
            expectedSize = ((Collection)descriptions).size();
        }
        this.resourceDescriptionMap = Maps.newHashMapWithExpectedSize((int)expectedSize);
        for (IResourceDescription desc : descriptions) {
            this.resourceDescriptionMap.put(desc.getURI(), desc);
        }
        this.lookupMap = Maps.newHashMapWithExpectedSize((int)(this.resourceDescriptionMap.size() * 2));
        for (IResourceDescription description : descriptions) {
            this.registerDescription(description, this.lookupMap);
        }
    }

    protected ResourceDescriptionsData(Map<URI, IResourceDescription> resourceDescriptionMap, Map<QualifiedName, Object> lookupMap) {
        this.resourceDescriptionMap = resourceDescriptionMap;
        this.lookupMap = lookupMap;
    }

    public ResourceDescriptionsData copy() {
        return new ResourceDescriptionsData(Maps.newHashMap(this.resourceDescriptionMap), this.copyLookupMap());
    }

    protected Map<QualifiedName, Object> copyLookupMap() {
        HashMap result = Maps.newHashMap(this.lookupMap);
        for (Map.Entry entry : result.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof Set)) continue;
            HashSet copiedValue = new HashSet((Set)value);
            if (copiedValue.size() <= 1) {
                throw new IllegalStateException("Unexpected number of elements in the value set: " + copiedValue.size() + " for " + entry.getKey());
            }
            entry.setValue(copiedValue);
        }
        return result;
    }

    public Iterable<IResourceDescription> getAllResourceDescriptions() {
        return this.resourceDescriptionMap.values();
    }

    public IResourceDescription getResourceDescription(URI uri) {
        return this.resourceDescriptionMap.get(uri);
    }

    public void removeDescription(URI uri) {
        IResourceDescription oldDescription = this.resourceDescriptionMap.remove(uri);
        if (oldDescription != null) {
            for (IEObjectDescription object : oldDescription.getExportedObjects()) {
                Set casted;
                QualifiedName objectName = object.getName().toLowerCase();
                Object existing = this.lookupMap.get(objectName);
                if (existing == oldDescription) {
                    this.lookupMap.remove(objectName);
                    continue;
                }
                if (!(existing instanceof Set) || !(casted = (Set)existing).remove(oldDescription)) continue;
                if (casted.size() == 1) {
                    this.lookupMap.put(objectName, casted.iterator().next());
                    continue;
                }
                if (!casted.isEmpty()) continue;
                this.lookupMap.remove(objectName);
            }
        }
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjects(final EClass type, final QualifiedName qualifiedName, final boolean ignoreCase) {
        Object existing = this.lookupMap.get(qualifiedName.toLowerCase());
        if (existing instanceof IResourceDescription) {
            return ((IResourceDescription)existing).getExportedObjects(type, qualifiedName, ignoreCase);
        }
        if (existing instanceof Set) {
            Set casted = (Set)existing;
            return Iterables.concat((Iterable)Iterables.transform((Iterable)casted, (Function)new Function<IResourceDescription, Iterable<IEObjectDescription>>(){

                public Iterable<IEObjectDescription> apply(IResourceDescription from) {
                    if (from != null) {
                        return from.getExportedObjects(type, qualifiedName, ignoreCase);
                    }
                    return Collections.emptyList();
                }
            }));
        }
        return Collections.emptyList();
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByObject(EObject object) {
        URI resourceURI = EcoreUtil2.getPlatformResourceOrNormalizedURI(object).trimFragment();
        IResourceDescription description = this.getResourceDescription(resourceURI);
        if (description == null) {
            return Collections.emptyList();
        }
        return description.getExportedObjectsByObject(object);
    }

    protected Iterable<IResourceDescription> getSelectables() {
        return this.resourceDescriptionMap.values();
    }

    public Set<URI> getAllURIs() {
        return this.resourceDescriptionMap.keySet();
    }

    public void addDescription(URI uri, IResourceDescription newDescription) {
        this.removeDescription(uri);
        if (newDescription != null) {
            this.resourceDescriptionMap.put(uri, newDescription);
            this.registerDescription(newDescription, this.lookupMap);
        }
    }

    protected void registerDescription(IResourceDescription description, Map<QualifiedName, Object> target) {
        for (IEObjectDescription object : description.getExportedObjects()) {
            QualifiedName lowerCase = object.getName().toLowerCase();
            Object existing = target.put(lowerCase, description);
            if (existing == null || existing == description) continue;
            Set<IResourceDescription> set = null;
            if (existing instanceof IResourceDescription) {
                set = Sets.newHashSetWithExpectedSize((int)2);
                set.add((IResourceDescription)existing);
            } else {
                set = (Set)existing;
            }
            set.add(description);
            target.put(lowerCase, set);
        }
    }

    public static class ResourceSetAdapter
    extends AdapterImpl {
        private ResourceDescriptionsData data;

        public ResourceSetAdapter(ResourceDescriptionsData data) {
            this.data = data;
        }

        public static ResourceDescriptionsData findResourceDescriptionsData(ResourceSet resourceSet) {
            if (resourceSet != null) {
                for (Adapter a : resourceSet.eAdapters()) {
                    if (!(a instanceof ResourceSetAdapter)) continue;
                    return ((ResourceSetAdapter)a).getResourceDescriptionsData();
                }
            }
            return null;
        }

        public static void installResourceDescriptionsData(ResourceSet resourceSet, ResourceDescriptionsData data) {
            if (ResourceSetAdapter.findResourceDescriptionsData(resourceSet) != null) {
                throw new IllegalStateException("Resource description data is already installed.");
            }
            ResourceSetAdapter resourceSetAdapter = new ResourceSetAdapter(data);
            resourceSet.eAdapters().add((Object)resourceSetAdapter);
        }

        public boolean isAdapterForType(Object type) {
            return type == ResourceDescriptionsData.class;
        }

        public ResourceDescriptionsData getResourceDescriptionsData() {
            return this.data;
        }
    }
}

