/*******************************************************************************
 * Copyright (c) 2013 Stefan Prisca.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Stefan Prisca - initial API and implementation
 ******************************************************************************/

package org.eclipse.recommenders.templates.rcp;

import org.eclipse.recommenders.templates.rcp.autoedit.TemplateAutoEditStrategyProvider;
import org.eclipse.recommenders.templates.rcp.syntaxhighlighting.TemplatesAntlrTokenToAttributeIdMapper;
import org.eclipse.recommenders.templates.rcp.syntaxhighlighting.TemplatesHighlightingConfiguration;
import org.eclipse.recommenders.templates.rcp.syntaxhighlighting.TemplatesSemanticHighlightingCalculator;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtext.ui.editor.autoedit.AbstractEditStrategyProvider;
import org.eclipse.xtext.ui.editor.syntaxcoloring.AbstractAntlrTokenToAttributeIdMapper;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfiguration;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator;

/**
 * Use this class to register components to be used within the IDE.
 */
@SuppressWarnings("all")
public class TemplateUiModule extends org.eclipse.recommenders.templates.rcp.AbstractTemplateUiModule {
    public TemplateUiModule(AbstractUIPlugin plugin) {
        super(plugin);
    }

    public Class<? extends IHighlightingConfiguration> bindIHighlightingConfiguration() {
        return TemplatesHighlightingConfiguration.class;
    }

    public Class<? extends ISemanticHighlightingCalculator> bindISemanticHighlightingCalculator() {
        return TemplatesSemanticHighlightingCalculator.class;
    }

    @Override
    public Class<? extends AbstractEditStrategyProvider> bindAbstractEditStrategyProvider() {
        return TemplateAutoEditStrategyProvider.class;
    }

    public Class<? extends AbstractAntlrTokenToAttributeIdMapper> bindAbstractAntlrTokenToAttributeIdMapper() {
        return TemplatesAntlrTokenToAttributeIdMapper.class;
    }

}
