/*******************************************************************************
 * Copyright (c) 2013 Stefan Prisca.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Stefan Prisca - initial API and implementation
 ******************************************************************************/
package org.eclipse.recommenders.templates.rcp.autoedit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.xtext.ui.editor.autoedit.AbstractEditStrategy;

public abstract class AbstractTemplatePartitionEditStrategy extends AbstractEditStrategy {

    protected boolean isCommandInPartition(IDocument document, int startOffset, String partitionToken) {
        return countPartitionEndTokens(document, startOffset, partitionToken) % 2 == 1;
    }

    private int countPartitionEndTokens(IDocument document, int startOffset, String partitionToken) {
        int offset = startOffset;
        int numberOfTokens = 0;

        while (offset >= 0) {
            try {
                if (document.get(offset - partitionToken.length(), partitionToken.length()).equals(partitionToken) && offset - partitionToken.length() - 1 < 0) {

                    numberOfTokens += 1;

                } else if (document.get(offset - partitionToken.length(), partitionToken.length()).equals(partitionToken)
                        && !document.get(offset - partitionToken.length() - 1, 1).equals("\\")) {

                    numberOfTokens += 1;

                }
            } catch (BadLocationException e) {
                return numberOfTokens;
            }
            offset -= partitionToken.length();
        }
        return numberOfTokens;
    }
}
