/*******************************************************************************
 * Copyright (c) 2013 Stefan Prisca.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Stefan Prisca - initial API and implementation
 ******************************************************************************/
package org.eclipse.recommenders.templates.rcp.autoedit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;

public class TemplatePartitionEndSkipEditStrategy extends AbstractTemplatePartitionEditStrategy {

    private final String partitionToken;

    public TemplatePartitionEndSkipEditStrategy(String partitionToken) {
        this.partitionToken = partitionToken;
    }

    @Override
    protected void internalCustomizeDocumentCommand(IDocument document, DocumentCommand command)
            throws BadLocationException {
        if (command.length == 0 && command.text.length() > 0 && command.offset < document.getLength()) {

            String part = document.get(command.offset, partitionToken.length());

            if (!part.equals(partitionToken)) {
                return;
            }

            if (command.offset - 1 >= 0 && document.get(command.offset - 1, 1).equals("\\")) {
                return;
            }

            if (!isCommandInPartition(document, command.offset, partitionToken)) {
                return;
            }

            String cmd = command.text.substring(0, partitionToken.length());

            if (cmd.equals(partitionToken)) {
                skipEditPartition(command);
            }

        }
    }

    private void skipEditPartition(DocumentCommand command) {
        command.length = partitionToken.length();
        command.text = partitionToken;
    }

}
