/*******************************************************************************
 * Copyright (c) 2013 Stefan Prisca.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Stefan Prisca - initial API and implementation
 ******************************************************************************/

package org.eclipse.recommenders.templates.rcp.autoedit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.xtext.ui.editor.autoedit.SingleLineTerminalsStrategy;

public class TemplateSingleLineTerminalEditStrategy extends SingleLineTerminalsStrategy {

    public TemplateSingleLineTerminalEditStrategy(String left, String right) {
        super(left, right, DEFAULT);
    }

    public TemplateSingleLineTerminalEditStrategy(String left, String right, StrategyPredicate strategy) {
        super(left, right, strategy);
    }

    @Override
    protected void handleInsertLeftTerminal(IDocument document, DocumentCommand command) throws BadLocationException {
        if (command.text.length() > 0 && appliedText(document, command).endsWith(getLeftTerminal())
                && !document.get(command.offset - 1, 1).equals("$"))
            super.handleInsertLeftTerminal(document, command);
    }
}
