package org.eclipse.recommenders.templates.serializer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.recommenders.templates.services.TemplateGrammarAccess;
import org.eclipse.recommenders.templates.template.Escape;
import org.eclipse.recommenders.templates.template.FullVariable;
import org.eclipse.recommenders.templates.template.Template;
import org.eclipse.recommenders.templates.template.TemplatePackage;
import org.eclipse.recommenders.templates.template.Text;
import org.eclipse.recommenders.templates.template.Variable;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic.Acceptor;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.GenericSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider.INodesForEObjectProvider;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class TemplateSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private TemplateGrammarAccess grammarAccess;
	
	public void createSequence(EObject context, EObject semanticObject) {
		if(semanticObject.eClass().getEPackage() == TemplatePackage.eINSTANCE) switch(semanticObject.eClass().getClassifierID()) {
			case TemplatePackage.ESCAPE:
				if(context == grammarAccess.getEscapeRule() ||
				   context == grammarAccess.getTemplateElementRule()) {
					sequence_Escape(context, (Escape) semanticObject); 
					return; 
				}
				else break;
			case TemplatePackage.FULL_VARIABLE:
				if(context == grammarAccess.getFullVariableRule() ||
				   context == grammarAccess.getVariableRule()) {
					sequence_FullVariable(context, (FullVariable) semanticObject); 
					return; 
				}
				else break;
			case TemplatePackage.TEMPLATE:
				if(context == grammarAccess.getTemplateRule()) {
					sequence_Template(context, (Template) semanticObject); 
					return; 
				}
				else break;
			case TemplatePackage.TEXT:
				if(context == grammarAccess.getTemplateElementRule() ||
				   context == grammarAccess.getTextRule()) {
					sequence_Text(context, (Text) semanticObject); 
					return; 
				}
				else break;
			case TemplatePackage.VARIABLE:
				if(context == grammarAccess.getVariableRule()) {
					sequence_Variable(context, (Variable) semanticObject); 
					return; 
				}
				else break;
			}
		if (errorAcceptor != null) errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Constraint:
	 *     (variable=Variable?)
	 */
	protected void sequence_Escape(EObject context, Escape semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         (id=TemplateIdentifier keyword=FieldTemplateKeyword arguments+=Type arguments+=Type*) | 
	 *         (id=TemplateIdentifier? keyword=VarTemplateKeyword (arguments+=Type arguments+=Type*)?) | 
	 *         (id=TemplateIdentifier keyword=LocalVarTemplateKeyword arguments+=Type arguments+=Type*) | 
	 *         (id=TemplateIdentifier keyword=ArgTypeTemplateKeyword arguments+=TemplateIdentifier arguments+=DECIMAL_NUMERAL?) | 
	 *         (id=TemplateIdentifier keyword=ElemTypeTemplateKeyword arguments+=TemplateIdentifier) | 
	 *         (id=TemplateIdentifier keyword=NewNameTemplateKeyword arguments+=Type) | 
	 *         (id=TemplateIdentifier keyword=NewTypeTemplateKeyword arguments+=Type) | 
	 *         (id=TemplateIdentifier? keyword=ImportTemplateKeyword arguments+=Type arguments+=Type*) | 
	 *         (id=TemplateIdentifier? keyword=ImportStaticTemplateKeyword arguments+=Type arguments+=Type*) | 
	 *         (id=TemplateIdentifier keyword=LinkTemplateKeyword arguments+=Proposal arguments+=Proposal*) | 
	 *         (id=TemplateIdentifier keyword=ArrayTemplateKeyword)
	 *     )
	 */
	protected void sequence_FullVariable(EObject context, FullVariable semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     elements+=TemplateElement*
	 */
	protected void sequence_Template(EObject context, Template semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         text=JavaKeyword | 
	 *         text=JavaIdentifier | 
	 *         text=JavaLiteral | 
	 *         text=JavaSeparators | 
	 *         text=JavaOperator | 
	 *         text=JavaComment | 
	 *         text=ANY_OTHER
	 *     )
	 */
	protected void sequence_Text(EObject context, Text semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     variable=TemplateIdentifier
	 */
	protected void sequence_Variable(EObject context, Variable semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, TemplatePackage.Literals.VARIABLE__VARIABLE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, TemplatePackage.Literals.VARIABLE__VARIABLE));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getVariableAccess().getVariableTemplateIdentifierParserRuleCall_1_0(), semanticObject.getVariable());
		feeder.finish();
	}
}
