/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BucketedEObjectDescription
extends EObjectDescription
implements IIdentifiableElementDescription {
    private final int bucketId;
    private final boolean visible;

    protected BucketedEObjectDescription(QualifiedName qualifiedName, JvmIdentifiableElement feature, int bucketId, boolean visible) {
        super(qualifiedName, (EObject)feature, null);
        this.bucketId = bucketId;
        this.visible = visible;
    }

    @Override
    public String getShadowingKey() {
        EObject object = this.getEObjectOrProxy();
        if (object instanceof JvmIdentifiableElement) {
            JvmIdentifiableElement identifiable = (JvmIdentifiableElement)object;
            StringBuilder builder = new StringBuilder(identifiable.getSimpleName());
            this.computeShadowingKey(identifiable, builder);
            return builder.toString();
        }
        return String.valueOf(this.getName().toString()) + (this.isVisible() ? (char)'+' : '-');
    }

    protected void computeShadowingKey(JvmIdentifiableElement identifiable, StringBuilder result) {
        if (identifiable instanceof JvmExecutable) {
            JvmExecutable executable = (JvmExecutable)identifiable;
            result.append('(');
            boolean first = true;
            for (JvmFormalParameter parameter : executable.getParameters()) {
                if (!first) {
                    result.append(',');
                } else {
                    first = false;
                }
                if (parameter.getParameterType() != null && parameter.getParameterType().getType() != null) {
                    result.append(parameter.getParameterType().getType().getIdentifier());
                    continue;
                }
                result.append("null");
            }
            result.append(')');
        }
        if (this.getImplicitFirstArgument() != null) {
            result.append(":implicitFirstArgument");
        }
        if (this.getImplicitReceiver() != null) {
            result.append(":implicitReceiver");
        }
        if (this.isTypeLiteral()) {
            result.append(":typeLiteral");
        }
        if (this.isVisible()) {
            result.append('+');
        } else {
            result.append('-');
        }
    }

    @Override
    public int getBucketId() {
        return this.bucketId;
    }

    @Override
    public LightweightTypeReference getImplicitReceiverType() {
        return null;
    }

    @Override
    public XExpression getImplicitReceiver() {
        return null;
    }

    @Override
    public Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getImplicitReceiverTypeParameterMapping() {
        return Collections.emptyMap();
    }

    @Override
    public EnumSet<ConformanceHint> getImplicitReceiverConformanceHints() {
        return ConformanceHint.fromFlags(this.getImplicitReceiverConformanceFlags());
    }

    @Override
    public int getImplicitReceiverConformanceFlags() {
        return 0;
    }

    @Override
    public LightweightTypeReference getSyntacticReceiverType() {
        return null;
    }

    @Override
    public XExpression getSyntacticReceiver() {
        return null;
    }

    @Override
    public boolean isSyntacticReceiverPossibleArgument() {
        return true;
    }

    @Override
    public Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getSyntacticReceiverTypeParameterMapping() {
        return Collections.emptyMap();
    }

    @Override
    public EnumSet<ConformanceHint> getSyntacticReceiverConformanceHints() {
        return ConformanceHint.fromFlags(this.getSyntacticReceiverConformanceFlags());
    }

    @Override
    public int getSyntacticReceiverConformanceFlags() {
        return 0;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public String toString() {
        return String.format("%s:%s [key: %s]", this.getName(), this.getElementOrProxy().getIdentifier(), this.getShadowingKey());
    }

    @Override
    public JvmIdentifiableElement getElementOrProxy() {
        return (JvmIdentifiableElement)this.getEObjectOrProxy();
    }

    @Override
    public XExpression getImplicitFirstArgument() {
        return null;
    }

    @Override
    public LightweightTypeReference getImplicitFirstArgumentType() {
        return null;
    }

    @Override
    public boolean isTypeLiteral() {
        return false;
    }

    @Override
    public boolean isAnonymousClassConstructorCall() {
        return false;
    }

    @Override
    public int getNumberOfIrrelevantParameters() {
        if (this.isExtension()) {
            return 1;
        }
        if (this.getImplicitFirstArgument() != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getNumberOfParameters() {
        JvmIdentifiableElement elementOrProxy = this.getElementOrProxy();
        if (elementOrProxy instanceof JvmExecutable) {
            int parameters = ((JvmExecutable)elementOrProxy).getParameters().size() - this.getNumberOfIrrelevantParameters();
            return parameters;
        }
        return 0;
    }

    @Override
    public boolean isValidStaticState() {
        return true;
    }
}

