/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.charts.rcp.charts;

import com.google.common.base.Preconditions;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.impl.PieSeriesImpl;

public final class PieChartFactory {
    public static Chart create(String title, String[] namesForSeries, Double[] valuesForSeries) {
        Preconditions.checkNotNull((Object)title);
        Preconditions.checkNotNull((Object)namesForSeries);
        Preconditions.checkNotNull((Object)valuesForSeries);
        Preconditions.checkArgument((namesForSeries.length == valuesForSeries.length ? 1 : 0) != 0, (Object)"check array length");
        ChartWithoutAxes chart = ChartWithoutAxesImpl.create();
        chart.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        chart.setDimension(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL);
        chart.setSeriesThickness(5.0);
        chart.getLegend().getOutline().setVisible(false);
        chart.getTitle().getLabel().getCaption().setValue(title);
        if (namesForSeries.length == 0 || valuesForSeries.length == 0) {
            chart.getTitle().getLabel().getCaption().setValue("No Data Available Yet");
        }
        TextDataSet categoryValues = TextDataSetImpl.create((Object)namesForSeries);
        NumberDataSet seriesOneValues = NumberDataSetImpl.create((Object)valuesForSeries);
        SampleData data = DataFactory.eINSTANCE.createSampleData();
        BaseSampleData sampleData = DataFactory.eINSTANCE.createBaseSampleData();
        sampleData.setDataSetRepresentation("");
        data.getBaseSampleData().add((Object)sampleData);
        OrthogonalSampleData orthogonal = DataFactory.eINSTANCE.createOrthogonalSampleData();
        orthogonal.setDataSetRepresentation("");
        orthogonal.setSeriesDefinitionIndex(0);
        data.getOrthogonalSampleData().add((Object)orthogonal);
        chart.setSampleData(data);
        Series category = SeriesImpl.create();
        category.setDataSet((DataSet)categoryValues);
        SeriesDefinition seriesDef = SeriesDefinitionImpl.create();
        chart.getSeriesDefinitions().add((Object)seriesDef);
        seriesDef.getSeriesPalette().shift(0);
        seriesDef.getSeries().add((Object)category);
        PieSeries pieSeries = (PieSeries)PieSeriesImpl.create();
        pieSeries.setDataSet((DataSet)seriesOneValues);
        pieSeries.setExplosion(5);
        SeriesDefinition series = SeriesDefinitionImpl.create();
        seriesDef.getSeriesDefinitions().add((Object)series);
        series.getSeries().add((Object)pieSeries);
        return chart;
    }

    private PieChartFactory() {
    }
}

