/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.charts.rcp.renderer;

import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.recommenders.stats.rcp.interfaces.IPageContent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChartPage
implements PaintListener,
IPageContent {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractChartPage.class);
    private IDeviceRenderer renderer;
    private Chart chart;
    private Composite parent;

    public AbstractChartPage() {
        PluginSettings setting = PluginSettings.instance();
        try {
            this.renderer = setting.getDevice("dv.SWT");
        }
        catch (Exception e) {
            LOG.debug(e.getMessage());
        }
    }

    public Composite createContent(Composite detailParent) {
        this.parent = this.createWrapperComposite(detailParent);
        this.chart = this.createChart();
        GridData gridData = new GridData(1808);
        Canvas canvas = new Canvas(this.parent, 2048);
        canvas.setLayoutData((Object)gridData);
        canvas.addPaintListener((PaintListener)this);
        new Label(this.parent, 0);
        return this.parent;
    }

    public void paintControl(PaintEvent paintEvent) {
        this.renderer.setProperty("device.output.context", (Object)paintEvent.gc);
        Composite composite = (Composite)paintEvent.getSource();
        Rectangle rectangle = composite.getClientArea();
        Bounds bounds = BoundsImpl.create((double)rectangle.x, (double)rectangle.y, (double)rectangle.width, (double)rectangle.height);
        bounds.scale(72.0 / (double)this.renderer.getDisplayServer().getDpiResolution());
        Generator generator = Generator.instance();
        try {
            generator.render(this.renderer, generator.build(this.renderer.getDisplayServer(), this.chart, bounds, null));
        }
        catch (Exception e) {
            LOG.debug(e.getMessage());
        }
    }

    private Composite createWrapperComposite(Composite parent) {
        Composite newComp = new Composite(parent, 0);
        newComp.setLayout((Layout)new GridLayout());
        newComp.setLayoutData((Object)new GridData(1808));
        new Label(newComp, 0);
        return newComp;
    }

    protected Composite getParent() {
        return this.parent;
    }

    protected void setChart(Chart chart) {
        this.chart = chart;
    }

    public abstract Chart createChart();
}

