/**
 * Copyright (c) 2013 Timur Achmetow.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Timur Achmetow - Initial API and implementation
 */
package org.eclipse.recommenders.stats.rcp.model;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.recommenders.stats.rcp.interfaces.ICategoryChildItem;
import org.eclipse.recommenders.stats.rcp.interfaces.ICategoryItem;
import org.eclipse.recommenders.stats.rcp.interfaces.IPageContent;
import org.eclipse.swt.graphics.Image;

import com.google.common.collect.ImmutableList;

public class TreeCategory implements ICategoryItem {
    private final Image image;
    private final String name;
    private final String description;
    private final IPageContent object;
    private List<ICategoryChildItem> items = new ArrayList<ICategoryChildItem>();

    public TreeCategory(String name, Image image, String description, IPageContent object) {
        this.name = name;
        this.image = image;
        this.description = description;
        this.object = object;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public List<ICategoryChildItem> getItems() {
        return ImmutableList.copyOf(items);
    }

    @Override
    public String toString() {
        return getName();
    }

    @Override
    public Image getIcon() {
        return image;
    }

    public String getDescription() {
        return description;
    }

    @Override
    public void addItem(ICategoryChildItem item) {
        items.add(item);
    }

    public IPageContent getPageObject() {
        return object;
    }
}
