/**
 * Copyright (c) 2013 Timur Achmetow.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Timur Achmetow - Initial API and implementation
 */
package org.eclipse.recommenders.stats.rcp.model;

import org.eclipse.recommenders.stats.rcp.interfaces.ICategoryChildItem;
import org.eclipse.recommenders.stats.rcp.interfaces.IPageContent;
import org.eclipse.swt.graphics.Image;

public class TreeItem implements ICategoryChildItem {

    private final String name;
    private final Image createImage;
    private final IPageContent object;
    private final String description;

    public TreeItem(String contentAssist, Image createImage, IPageContent object, String description) {
        name = contentAssist;
        this.createImage = createImage;
        this.object = object;
        this.description = description;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public Image getIcon() {
        return createImage;
    }

    @Override
    public String toString() {
        return getName();
    }

    public IPageContent getPageObject() {
        return object;
    }

    public String getDescription() {
        if (description == null) {
            return "";
        }
        return description;
    }
}
