/**
 * Copyright (c) 2015 Akif Etkue.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Akif Etkue - Initial API and implementation
 */
package org.eclipse.recommenders.stats.rcp.model;

import java.util.List;

public class WorkspaceProjectType {

    private final String name;
    private final List<String> labelList;
    private final String fileCount;
    private final long bytes;

    public WorkspaceProjectType(String name, List<String> labelList, int fileCount, long bytes) {
        this.name = name;
        this.labelList = labelList;
        this.fileCount = Integer.toString(fileCount);
        this.bytes = bytes;
    }

    public String getName() {
        return name;
    }

    public String getFileCount() {
        return fileCount;
    }

    public long getBytes() {
        return bytes;
    }

    public String getType() {
        String displayLabel = null;
        if (labelList == null || labelList.isEmpty()) {
            return "Unknown Project Type";
        }
        for (String label : labelList) {
            if (label == null || label.isEmpty()) {
                continue;
            }
            label = label.replace(" Development", "");
            if (displayLabel == null) {
                displayLabel = label;
            } else {
                displayLabel += "/" + label;
            }
        }
        return displayLabel + " Project";
    }
}
