/**
 * Copyright (c) 2015 Akif Etkue.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Akif Etkue - Initial API and implementation
 */
package org.eclipse.recommenders.stats.rcp.ui.data;

import java.io.File;
import java.util.List;

public class WorkspaceDataHelper {

    public static void collectAllFilesFor(final File folder, List<File> collectedFiles) {
        if (folder.isDirectory()) {
            for (final File fileEntry : folder.listFiles()) {
                if (fileEntry.isDirectory() && isNotSettingsFolder(fileEntry)) {
                    collectAllFilesFor(fileEntry, collectedFiles);
                } else {
                    if (fileEntry.isFile() && isNotResourceFile(fileEntry)) {
                        collectedFiles.add(fileEntry);
                    }
                }
            }
        }
    }

    public static long getSizeFor(List<File> list) {
        long size = 0L;
        for (File file : list) {
            size += file.length();
        }
        return size;
    }

    private static boolean isNotSettingsFolder(final File fileEntry) {
        return !fileEntry.getName().equals(".settings");
    }

    private static boolean isNotResourceFile(final File fileEntry) {
        return !fileEntry.getName().startsWith(".");
    }
}
