/**
 * Copyright (c) 2017 Julian Wolpert.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Julian Wolpert - Initial API and implementation
 */
package org.eclipse.recommenders.stats.rcp.ui.util;

import static java.lang.String.format;

import java.util.Collection;
import java.util.Date;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.recommenders.stats.rcp.events.CompletionEvent;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.stats.rcp.model.TriggeredCommandObject;
import org.eclipse.recommenders.stats.rcp.ui.data.StatisticData;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

import com.google.common.collect.Iterables;

public class CommandsUtil {

    private static ICommandService commandService = (ICommandService) PlatformUI.getWorkbench()
            .getService(ICommandService.class);

    public static String getCommandName(TriggeredCommandObject commandObj) {
        Command command = commandService.getCommand(commandObj.commandID);
        try {
            return command.getName();
        } catch (NotDefinedException e) {
            return "No name found";
        }
    }

    public static String getCommandDescription(TriggeredCommandObject commandObj) {
        Command command = commandService.getCommand(commandObj.commandID);
        try {
            return command.getDescription() != null ? command.getDescription() : "";
        } catch (NotDefinedException e) {
            return "No description found";
        }
    }

    public static String getDescriptionText(IDataPersistenceService persistenceService) {
        Collection<CompletionEvent> okayEvents = StatisticData.create(persistenceService).getOkayEvents();
        if (okayEvents.size() > 0) {
            Date start = new Date(Iterables.getFirst(okayEvents, null).sessionStarted);
            return format("%tF", start);
        }
        return "";
    }

    public static int getTriggeredCommandsSize(Collection<TriggeredCommandObject> model) {
        int counter = 0;
        if (model != null) {
            for (TriggeredCommandObject command : model) {
                counter += command.count;
            }
        }
        return counter;
    }
}
