/**
 * Copyright (c) 2017 Julian Wolpert.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Julian Wolpert - Initial API and implementation
 */
package org.eclipse.recommenders.stats.rcp.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import org.eclipse.recommenders.stats.rcp.model.TriggeredCommandObject;

public class EclipseCategoryData {

    public static double getTotalNumberHours(Map<Long, Long> rawData) {
        if (rawData == null || rawData.isEmpty()) {
            return 0.0;
        }
        long result = 0;
        for (Long day : rawData.keySet()) {
            Long hours = rawData.get(day);
            result += hours;
        }
        return convertToHours(result);
    }

    public static double getMinHoursPerDay(Map<Long, Long> rawData) {
        if (rawData == null || rawData.isEmpty()) {
            return 0.0;
        }
        long minHours = Long.MAX_VALUE;
        for (Long day : rawData.keySet()) {
            Long hours = rawData.get(day);
            if (hours < minHours) {
                minHours = hours;
            }
        }
        return convertToHours(minHours);
    }

    public static double getMaxHoursPerDay(Map<Long, Long> rawData) {
        if (rawData == null || rawData.isEmpty()) {
            return 0.0;
        }
        long maxHours = Long.MIN_VALUE;
        for (Long day : rawData.keySet()) {
            Long hours = rawData.get(day);
            if (hours > maxHours) {
                maxHours = hours;
            }
        }
        return convertToHours(maxHours);
    }

    public static List<TriggeredCommandObject> getFavouriteCommands(Collection<TriggeredCommandObject> model) {
        List<TriggeredCommandObject> result = new ArrayList<>();
        TriggeredCommandObject first = new TriggeredCommandObject(null, 0);
        TriggeredCommandObject second = new TriggeredCommandObject(null, 0);
        TriggeredCommandObject third = new TriggeredCommandObject(null, 0);
        result.add(first);
        result.add(second);
        result.add(third);

        if (model == null || model.isEmpty()) {
            return result;
        }

        for (TriggeredCommandObject commandObj : model) {
            if (commandObj.count > first.count) {
                third = second;
                second = first;
                first = commandObj;
            } else if (commandObj.count > second.count && commandObj.count <= first.count) {
                third = second;
                second = commandObj;
            } else if (commandObj.count > third.count && commandObj.count <= second.count) {
                third = commandObj;
            }
        }
        result.set(0, first);
        result.set(1, second);
        result.set(2, third);

        return result;
    }

    public static Double convertToHours(long data) {
        double formatHours = (double) data / TimeUnit.HOURS.toMillis(1);
        return Math.round(formatHours * 100) / 100d;
    }
}
