/**
 * Copyright (c) 2015 Clemens Henker.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Clemens Henker - Initial API and implementation
 *    Timur Achmetow - API through some helper methods extended
 */
package org.eclipse.recommenders.stats.rcp.ui.util;

import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class LabelHelperFactory {

    private LabelHelperFactory() {
    }

    public static Label createCounter(Composite parent, int size) {
        Label counter = new Label(parent, SWT.NONE);
        counter.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, true, false));
        update(counter, size);
        counter.setForeground(JFaceResources.getColorRegistry().get(JFacePreferences.COUNTER_COLOR));
        return counter;
    }

    public static void update(Label counter, int size) {
        counter.setText("Count: " + size);
        counter.pack();
    }

    public static void createLabelWithColor(Composite parent, String firstLabel, String coloredLabel) {
        Composite cmp = new Composite(parent, SWT.NONE);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        cmp.setLayout(layout);

        new Label(cmp, SWT.NONE).setText(firstLabel);
        createLabelWithColor(cmp, coloredLabel);
    }

    public static void createLabelWithColor(Composite parent, String text) {
        Label label = createLabelWithColor(parent);
        label.setText(text);
    }

    public static Label createLabelWithColor(Composite parent) {
        Label label = new Label(parent, SWT.NONE);
        label.setForeground(JFaceResources.getColorRegistry().get(JFacePreferences.COUNTER_COLOR));
        return label;
    }

    public static void createSeparatorLabel(Composite parent) {
        new Label(parent, SWT.NONE);
    }

    public static void createTwoSeparatorLabel(Composite parent) {
        new Label(parent, SWT.NONE);
        new Label(parent, SWT.NONE);
    }
}
