/**
 * Copyright (c) 2016 Timur Achmetow.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Timur Achmetow - Initial API and implementation
 */
package org.eclipse.recommenders.stats.rcp.ui.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class UiFormsFactory {

    public static Section createSection(final Composite parent, final FormToolkit toolkit, final String title) {
        Section section = toolkit.createSection(parent, Section.TITLE_BAR | Section.DESCRIPTION);
        section.setText(title);
        section.setLayoutData(new GridData(GridData.FILL_BOTH));
        return section;
    }

    public static Composite createCompositeForSection(final FormToolkit toolkit, Section masterSection) {
        final Composite newComp = toolkit.createComposite(masterSection);
        newComp.setLayout(new GridLayout());
        newComp.setLayoutData(new GridData(GridData.FILL_BOTH));
        masterSection.setClient(newComp);
        return newComp;
    }

    public static void createSeparator(Composite parent) {
        final Label separator = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        separator.setBackground(parent.getBackground());
        separator.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false));
        separator.pack();
    }

    public static UiFormsSash createSash(Composite mainComposite, FormToolkit toolkit) {
        final ManagedForm managedForm = new ManagedForm(toolkit, null);
        UiFormsSash sashForm = new UiFormsSash(mainComposite, SWT.NULL);
        sashForm.setData("form", managedForm); //$NON-NLS-1$
        toolkit.adapt(sashForm, false, false);
        sashForm.setLayoutData(new GridData(GridData.FILL_BOTH));
        sashForm.SASH_WIDTH = 8;
        return sashForm;
    }
}
