/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.events;

import javax.inject.Inject;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.stats.rcp.model.TriggeredCommandObject;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class TriggeredCommandCollector
implements IStartup,
IExecutionListener {
    private final IDataPersistenceService persistenceService;

    @Inject
    public TriggeredCommandCollector(IDataPersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void earlyStartup() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        if (commandService != null) {
            commandService.addExecutionListener((IExecutionListener)this);
        }
    }

    public void preExecute(String commandId, ExecutionEvent event) {
        TriggeredCommandObject triggeredCommand = new TriggeredCommandObject(commandId, System.currentTimeMillis());
        this.persistenceService.record(triggeredCommand, "org.eclipse.recommenders.stats.rcp.channels.triggeredCommands");
    }

    public void postExecuteSuccess(String commandId, Object returnValue) {
    }

    public void postExecuteFailure(String commandId, ExecutionException exception) {
    }

    public void notHandled(String commandId, NotHandledException exception) {
    }
}

