/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.persistence;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.gson.FieldNameTypeAdapter;
import org.eclipse.recommenders.utils.gson.FileTypeAdapter;
import org.eclipse.recommenders.utils.gson.ISO8601DateParser;
import org.eclipse.recommenders.utils.gson.MethodNameTypeAdapter;
import org.eclipse.recommenders.utils.gson.MultimapTypeAdapter;
import org.eclipse.recommenders.utils.gson.PackageNameTypeAdapter;
import org.eclipse.recommenders.utils.gson.TypeNameTypeAdapter;
import org.eclipse.recommenders.utils.gson.UuidTypeAdapter;
import org.eclipse.recommenders.utils.names.IFieldName;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.IPackageName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmFieldName;
import org.eclipse.recommenders.utils.names.VmMethodName;
import org.eclipse.recommenders.utils.names.VmPackageName;
import org.eclipse.recommenders.utils.names.VmTypeName;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPersistenceService
implements IDataPersistenceService {
    private static final Logger LOG = LoggerFactory.getLogger(DataPersistenceService.class);

    @Override
    public <E> void record(E event, String channelId) {
        File dest = this.getCompletionLogLocation(channelId);
        if (event != null) {
            try {
                Gson gson = this.initGsonObject(channelId);
                Files.append((CharSequence)(String.valueOf(gson.toJson(event)) + IOUtils.LINE_SEPARATOR), (File)dest, (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                LOG.debug(e.getMessage());
            }
        }
    }

    @Override
    public <E> Collection<E> retrieve(Class<E> eventClass, String channelId) {
        File dest = this.getCompletionLogLocation(channelId);
        ArrayList events = Lists.newArrayList();
        if (dest.exists()) {
            Gson gson = this.initGsonObject(channelId);
            try {
                for (String json : Files.readLines((File)dest, (Charset)Charsets.UTF_8)) {
                    Object event = gson.fromJson(json, eventClass);
                    if (!eventClass.isInstance(event)) continue;
                    events.add(event);
                }
            }
            catch (IOException e) {
                LOG.debug(e.getMessage());
            }
        }
        LOG.debug("Load data from file: " + dest.getPath());
        return events;
    }

    private File getCompletionLogLocation(String channelId) {
        Bundle bundle = FrameworkUtil.getBundle(DataPersistenceService.class);
        IPath location = Platform.getStateLocation((Bundle)bundle);
        return new File(location.toFile(), String.valueOf(channelId) + ".txt");
    }

    private Gson initGsonObject(String channelId) {
        if ("org.eclipse.recommenders.stats.rcp.channels.completionEvents".equals(channelId)) {
            GsonBuilder builder = new GsonBuilder();
            builder.registerTypeAdapter(VmMethodName.class, (Object)new MethodNameTypeAdapter());
            builder.registerTypeAdapter(IMethodName.class, (Object)new MethodNameTypeAdapter());
            builder.registerTypeAdapter(VmTypeName.class, (Object)new TypeNameTypeAdapter());
            builder.registerTypeAdapter(ITypeName.class, (Object)new TypeNameTypeAdapter());
            builder.registerTypeAdapter(VmFieldName.class, (Object)new FieldNameTypeAdapter());
            builder.registerTypeAdapter(IFieldName.class, (Object)new FieldNameTypeAdapter());
            builder.registerTypeAdapter(VmPackageName.class, (Object)new PackageNameTypeAdapter());
            builder.registerTypeAdapter(IPackageName.class, (Object)new PackageNameTypeAdapter());
            builder.registerTypeAdapter(File.class, (Object)new FileTypeAdapter());
            builder.registerTypeAdapter(UUID.class, (Object)new UuidTypeAdapter());
            builder.registerTypeAdapter(Date.class, (Object)new ISO8601DateParser());
            builder.registerTypeAdapter(Multimap.class, (Object)new MultimapTypeAdapter());
            return builder.create();
        }
        return new Gson();
    }
}

