/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.ui.data;

import com.google.common.annotations.VisibleForTesting;
import com.ibm.icu.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.stats.rcp.model.WorkbenchSession;
import org.eclipse.recommenders.stats.rcp.ui.data.WeekDays;

public class WorkbenchData {
    private final IDataPersistenceService service;

    private WorkbenchData(IDataPersistenceService service) {
        this.service = service;
    }

    public static WorkbenchData create(IDataPersistenceService service) {
        return new WorkbenchData(service);
    }

    public Map<WeekDays, Long> getHoursForWeekdays() {
        Map<Long, Long> filteredRawData = WorkbenchData.filterSameDaysInRawData(this.getData());
        Map<WeekDays, List<Long>> rawData = WorkbenchData.getRawWeekDayData(filteredRawData);
        Map<WeekDays, Long> preparedData = WorkbenchData.getPreparedWeekDayData(rawData);
        return WorkbenchData.fillEmptyDays(preparedData);
    }

    public Map<WeekDays, List<Long>> getRawWeekDayData() {
        Map<Long, Long> filteredRawData = WorkbenchData.filterSameDaysInRawData(this.getData());
        return WorkbenchData.getRawWeekDayData(filteredRawData);
    }

    public Map<Long, Long> getRawData() {
        return WorkbenchData.filterSameDaysInRawData(this.getData());
    }

    @VisibleForTesting
    protected static Map<WeekDays, Long> fillEmptyDays(Map<WeekDays, Long> preparedData) {
        TreeMap<WeekDays, Long> filledData = new TreeMap<WeekDays, Long>();
        WeekDays[] weekDaysArray = WeekDays.values();
        int n = weekDaysArray.length;
        int n2 = 0;
        while (n2 < n) {
            WeekDays day = weekDaysArray[n2];
            if (preparedData.containsKey((Object)day)) {
                filledData.put(day, preparedData.get((Object)day));
            } else {
                filledData.put(day, 0L);
            }
            ++n2;
        }
        return filledData;
    }

    @VisibleForTesting
    protected static Map<WeekDays, Long> getPreparedWeekDayData(Map<WeekDays, List<Long>> rawWeekDayData) {
        HashMap<WeekDays, Long> preparedData = new HashMap<WeekDays, Long>();
        for (WeekDays day : rawWeekDayData.keySet()) {
            List<Long> timeList = rawWeekDayData.get((Object)day);
            if (timeList.isEmpty()) continue;
            long timeAvg = 0L;
            for (Long time : timeList) {
                timeAvg += time.longValue();
            }
            long avg = timeAvg / (long)timeList.size();
            preparedData.put(day, avg);
        }
        return preparedData;
    }

    @VisibleForTesting
    protected static Map<Long, Long> filterSameDaysInRawData(Collection<WorkbenchSession> dataList) {
        HashMap daysToSessions = new HashMap();
        if (dataList != null) {
            for (WorkbenchSession workbenchObject : dataList) {
                String day = new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH).format(workbenchObject.getStart());
                if (!daysToSessions.containsKey(day)) {
                    daysToSessions.put(day, new ArrayList());
                }
                ((List)daysToSessions.get(day)).add(workbenchObject);
            }
        }
        HashMap<Long, Long> dayToHourPerDay = new HashMap<Long, Long>();
        for (String day : daysToSessions.keySet()) {
            List list = (List)daysToSessions.get(day);
            if (list.isEmpty()) continue;
            long hoursSum = 0L;
            for (WorkbenchSession session : list) {
                hoursSum += session.getEnd().getTime() - session.getStart().getTime();
            }
            dayToHourPerDay.put(((WorkbenchSession)list.get(0)).getStart().getTime(), hoursSum);
        }
        return dayToHourPerDay;
    }

    @VisibleForTesting
    protected static Map<WeekDays, List<Long>> getRawWeekDayData(Map<Long, Long> dataList) {
        HashMap<WeekDays, List<Long>> weekDayMap = new HashMap<WeekDays, List<Long>>();
        if (dataList != null) {
            for (Long startTime : dataList.keySet()) {
                String day = new SimpleDateFormat("E", Locale.ENGLISH).format((Object)startTime);
                WeekDays weekDay = WeekDays.getEnum(day);
                if (!weekDayMap.containsKey((Object)weekDay)) {
                    weekDayMap.put(weekDay, new ArrayList());
                }
                long hoursPerDay = dataList.get(startTime);
                ((List)weekDayMap.get((Object)weekDay)).add(hoursPerDay);
            }
        }
        return weekDayMap;
    }

    private Collection<WorkbenchSession> getData() {
        return this.service.retrieve(WorkbenchSession.class, "org.eclipse.recommenders.stats.rcp.channels.workbenchSession");
    }
}

