/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.ui.data;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.recommenders.stats.rcp.model.WorkspaceContentType;
import org.eclipse.recommenders.stats.rcp.ui.data.WorkspaceDataHelper;

public class WorkspaceFileData {
    private int totalFileSize;
    private long totalByteSize;

    public List<WorkspaceContentType> getPreparedData() {
        List<File> collectedFiles = this.readFiles();
        Map<String, List<File>> dataMap = this.prepareData(collectedFiles);
        this.totalFileSize = collectedFiles.size();
        this.totalByteSize = this.calculateTotalSize(dataMap);
        return this.buildModelObjects(dataMap);
    }

    private List<File> readFiles() {
        ArrayList<File> collectedFiles = new ArrayList<File>();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = workspaceRoot.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.exists()) {
                IPath path = project.getLocation();
                WorkspaceDataHelper.collectAllFilesFor(path.toFile(), collectedFiles);
            }
            ++n2;
        }
        return collectedFiles;
    }

    @VisibleForTesting
    protected Map<String, List<File>> prepareData(List<File> collectedFiles) {
        HashMap<String, List<File>> dataMap = new HashMap<String, List<File>>();
        if (collectedFiles != null) {
            for (File file : collectedFiles) {
                String extension = FilenameUtils.getExtension((String)file.getName());
                if (extension == null || extension.isEmpty()) continue;
                if (!dataMap.containsKey(extension)) {
                    dataMap.put(extension, new ArrayList());
                }
                ((List)dataMap.get(extension)).add(file);
            }
        }
        return dataMap;
    }

    @VisibleForTesting
    protected List<WorkspaceContentType> buildModelObjects(Map<String, List<File>> dataMap) {
        ArrayList<WorkspaceContentType> modelList = new ArrayList<WorkspaceContentType>();
        if (dataMap != null) {
            for (String extension : dataMap.keySet()) {
                List<File> list = dataMap.get(extension);
                modelList.add(new WorkspaceContentType(extension, list.size(), WorkspaceDataHelper.getSizeFor(list)));
            }
        }
        return modelList;
    }

    private long calculateTotalSize(Map<String, List<File>> dataMap) {
        long size = 0L;
        for (String extension : dataMap.keySet()) {
            size += WorkspaceDataHelper.getSizeFor(dataMap.get(extension));
        }
        return size;
    }

    public int getTotalFiles() {
        return this.totalFileSize;
    }

    public long getTotalSize() {
        return this.totalByteSize;
    }
}

