/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.ui.util;

import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class DateFormatter {
    public final String formatUnit(Date past, Date now) {
        Preconditions.checkNotNull((Object)past);
        Preconditions.checkNotNull((Object)now);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(now.getTime() - past.getTime());
        long hours = TimeUnit.MILLISECONDS.toHours(now.getTime() - past.getTime());
        long days = TimeUnit.MILLISECONDS.toDays(now.getTime() - past.getTime());
        if (days > 0L) {
            return MessageFormat.format("{0,choice,1#1 day ago|1<{0,number,integer} days ago}", days);
        }
        if (hours > 0L) {
            return MessageFormat.format("{0,choice,1#1 hour ago|1<{0,number,integer} hours ago}", hours);
        }
        if (minutes >= 0L) {
            return MessageFormat.format("{0,choice,0#0 minutes ago|1#1 minute ago|1<{0,number,integer} minutes ago}", minutes);
        }
        return null;
    }
}

