/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.ui.util;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class LabelHelperFactory {
    private LabelHelperFactory() {
    }

    public static Label createCounter(Composite parent, int size) {
        Label counter = new Label(parent, 0);
        counter.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        LabelHelperFactory.update(counter, size);
        counter.setForeground(JFaceResources.getColorRegistry().get("COUNTER_COLOR"));
        return counter;
    }

    public static void update(Label counter, int size) {
        counter.setText("Count: " + size);
        counter.pack();
    }

    public static void createLabelWithColor(Composite parent, String firstLabel, String coloredLabel) {
        Composite cmp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        cmp.setLayout((Layout)layout);
        new Label(cmp, 0).setText(firstLabel);
        LabelHelperFactory.createLabelWithColor(cmp, coloredLabel);
    }

    public static void createLabelWithColor(Composite parent, String text) {
        Label label = LabelHelperFactory.createLabelWithColor(parent);
        label.setText(text);
    }

    public static Label createLabelWithColor(Composite parent) {
        Label label = new Label(parent, 0);
        label.setForeground(JFaceResources.getColorRegistry().get("COUNTER_COLOR"));
        return label;
    }

    public static void createSeparatorLabel(Composite parent) {
        new Label(parent, 0);
    }

    public static void createTwoSeparatorLabel(Composite parent) {
        new Label(parent, 0);
        new Label(parent, 0);
    }
}

