/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.ui.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.IManagedForm;

public class UiFormsSash
extends SashForm {
    private final List<Sash> sashes = new ArrayList<Sash>();
    private final Listener listener = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 6: {
                    event.widget.setData("hover", (Object)Boolean.TRUE);
                    ((Control)event.widget).redraw();
                    break;
                }
                case 7: {
                    event.widget.setData("hover", null);
                    ((Control)event.widget).redraw();
                    break;
                }
                case 9: {
                    UiFormsSash.this.onSashPaint(event);
                    break;
                }
                case 11: {
                    UiFormsSash.this.hookSashListeners();
                    break;
                }
            }
        }
    };

    public UiFormsSash(Composite parent, int style) {
        super(parent, style);
    }

    public void layout(boolean changed) {
        super.layout(changed);
        this.hookSashListeners();
    }

    public void layout(Control[] children) {
        super.layout(children);
        this.hookSashListeners();
    }

    public void hookResizeListener() {
        Control[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            if (!(children[i] instanceof Sash)) {
                children[i].addListener(11, this.listener);
            }
            ++i;
        }
    }

    private void onSashPaint(Event event) {
        Sash sash = (Sash)event.widget;
        IManagedForm form = (IManagedForm)sash.getParent().getData("form");
        FormColors colors = form.getToolkit().getColors();
        GC graphics = event.gc;
        Boolean hover = (Boolean)sash.getData("hover");
        graphics.setBackground(colors.getColor("org.eclipse.ui.forms.TB_BG"));
        graphics.setForeground(colors.getColor("org.eclipse.ui.forms.TB_BORDER"));
        Point size = sash.getSize();
        if (hover != null) {
            graphics.fillRectangle(0, 0, size.x, size.y);
        }
    }

    private void hookSashListeners() {
        this.purgeSashes();
        Control[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            Sash sash;
            if (children[i] instanceof Sash && !this.sashes.contains(sash = (Sash)children[i])) {
                sash.addListener(9, this.listener);
                sash.addListener(6, this.listener);
                sash.addListener(7, this.listener);
                this.sashes.add(sash);
            }
            ++i;
        }
    }

    private void purgeSashes() {
        Iterator<Sash> iter = this.sashes.iterator();
        while (iter.hasNext()) {
            Sash sash = iter.next();
            if (!sash.isDisposed()) continue;
            iter.remove();
        }
    }
}

