/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.ui.views;

import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import javax.inject.Inject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.recommenders.rcp.utils.TableSortConfigurator;
import org.eclipse.recommenders.stats.rcp.events.CompletionEvent;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.stats.rcp.interfaces.IPageContent;
import org.eclipse.recommenders.stats.rcp.ui.data.StatisticData;
import org.eclipse.recommenders.stats.rcp.ui.util.DateFormatter;
import org.eclipse.recommenders.stats.rcp.ui.util.LabelHelperFactory;
import org.eclipse.recommenders.stats.rcp.ui.util.TableSorters;
import org.eclipse.recommenders.stats.rcp.ui.util.TableViewerFactory;
import org.eclipse.recommenders.utils.Bags;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.swt.widgets.Composite;

public class CompletionTypeView
implements IPageContent {
    private final Collection<CompletionEvent> okayEvents;
    private final IDataPersistenceService persistenceService;

    @Inject
    public CompletionTypeView(IDataPersistenceService persistenceService) {
        this.persistenceService = persistenceService;
        this.okayEvents = StatisticData.create(persistenceService).getOkayEvents();
    }

    @Override
    public Composite createContent(Composite detailParent) {
        HashMultiset proposalKindBag = HashMultiset.create();
        ArrayListMultimap multiMap = ArrayListMultimap.create();
        CompletionEvent.ProposalKind[] proposalKindArray = CompletionEvent.ProposalKind.values();
        int n = proposalKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            final CompletionEvent.ProposalKind kind = proposalKindArray[n2];
            Collection byKind = Collections2.filter(this.okayEvents, (Predicate)new Predicate<CompletionEvent>((Multimap)multiMap){
                private final /* synthetic */ Multimap val$multiMap;
                {
                    this.val$multiMap = multimap;
                }

                public boolean apply(CompletionEvent input) {
                    if (kind == input.applied) {
                        if (!this.val$multiMap.containsEntry((Object)kind, (Object)input)) {
                            this.val$multiMap.put((Object)kind, (Object)input);
                        }
                        return true;
                    }
                    return false;
                }
            });
            if (byKind.size() > 0) {
                proposalKindBag.add((Object)kind, byKind.size());
            }
            ++n2;
        }
        List input = Bags.topUsingCount((Multiset)proposalKindBag, (int)30);
        Composite newComp = TableViewerFactory.createWrapperComposite(detailParent);
        LabelHelperFactory.createSeparatorLabel(newComp);
        LabelHelperFactory.createLabelWithColor(newComp, "Total number of triggered completion types: ", Integer.toString(this.getSize(input)));
        Composite comp = new Composite(newComp, 0);
        TableColumnLayout layout = TableViewerFactory.createTableColumnLayout(comp);
        final TableViewer viewer = TableViewerFactory.createTableViewer(comp);
        TableViewerColumn completionTypeColumn = TableViewerFactory.createColumn("Completion Type", viewer, 150, layout, 50, 16384);
        TableViewerColumn usedCompletionColumn = TableViewerFactory.createColumn("Used", viewer, 60, layout, 15, 131072);
        TableViewerColumn lastUsedColumn = TableViewerFactory.createColumn("Last used", viewer, 110, layout, 35, 131072);
        TableSortConfigurator.newConfigurator((TableViewer)viewer, (IAction)new Action(){

            public void run() {
                viewer.refresh();
            }
        }).add(completionTypeColumn.getColumn(), TableSorters.Completion.TYPE_COMPARATOR).add(usedCompletionColumn.getColumn(), TableSorters.Completion.USED_COMPARATOR).add(lastUsedColumn.getColumn(), TableSorters.Completion.getLastUsedComparator((Multimap<CompletionEvent.ProposalKind, CompletionEvent>)multiMap, this.persistenceService)).initialize(usedCompletionColumn.getColumn(), 1024).configure();
        TableViewerFactory.addMenu(viewer);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ProposalLabelProvider((Multimap<CompletionEvent.ProposalKind, CompletionEvent>)multiMap));
        viewer.setInput((Object)input);
        LabelHelperFactory.createCounter(newComp, input.size());
        return newComp;
    }

    private int getSize(List<Multiset.Entry<CompletionEvent.ProposalKind>> input) {
        int result = 0;
        for (Multiset.Entry<CompletionEvent.ProposalKind> entry : input) {
            result += entry.getCount();
        }
        return result;
    }

    public class ProposalLabelProvider
    extends StyledCellLabelProvider {
        private Multimap<CompletionEvent.ProposalKind, CompletionEvent> eventsByKind;

        public ProposalLabelProvider(Multimap<CompletionEvent.ProposalKind, CompletionEvent> multiMap) {
            this.eventsByKind = multiMap;
        }

        public void update(ViewerCell cell) {
            StyledString cellText = new StyledString();
            Multiset.Entry element = (Multiset.Entry)Checks.cast((Object)cell.getElement());
            CompletionEvent.ProposalKind kind = (CompletionEvent.ProposalKind)((Object)element.getElement());
            switch (cell.getColumnIndex()) {
                case 0: {
                    cellText.append(kind.toString().toLowerCase().replace('_', ' '));
                    break;
                }
                case 1: {
                    int count = element.getCount();
                    cellText.append(Integer.toString(count), StyledString.COUNTER_STYLER);
                    break;
                }
                case 2: {
                    Date past = new Date(this.getLastSessionStartedFor(kind));
                    cellText.append(new DateFormatter().formatUnit(past, new Date()));
                }
            }
            cell.setText(cellText.toString());
            cell.setStyleRanges(cellText.getStyleRanges());
        }

        public Long getLastSessionStartedFor(CompletionEvent.ProposalKind proposal) {
            Collection collection = this.eventsByKind.get((Object)proposal);
            TreeSet<Long> sessionSet = new TreeSet<Long>();
            for (CompletionEvent completionEvent : collection) {
                sessionSet.add(completionEvent.sessionEnded);
            }
            return (Long)sessionSet.last();
        }
    }
}

